/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling;

/**
 * Represents the type of {@link ProfilingProducerScope} within which the profiling data produced by a
 * {@link ProfilingDataProducer} will be bound to.
 *
 * When {@link ProfilingDataProducer#triggerProfilingEvent} is invoked, this scope will be taken into account to evaluate if there
 * are consumers enabled/disabled for it.
 */
public enum ProfilingProducerScopeType {

  /**
   * Producer scope type that represents an artifact.
   */
  ARTIFACT_SCOPE_TYPE;
}
