/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling;

import org.mule.runtime.api.profiling.type.ProfilingEventType;

/**
 * Represents the scope associated to a {@link ProfilingDataProducer}. When a {@link ProfilingDataProducer} is retrieved from
 * {@link ProfilingService#getProfilingDataProducer(ProfilingEventType, ProfilingProducerScope)}, it will be associated to the
 * scope defined by the {@link #getProducerScopeIdentifier()} and {@link #getProducerScopeTypeIdentifier()}.
 * <p>
 * For example, if we want to produce data associated to an artifact, a {@link ProfilingDataProducer} should retrieved through
 * {@link ProfilingService#getProfilingDataProducer(ProfilingEventType, ProfilingProducerScope)} with an implementation of
 * {@link ProfilingProducerScope} that represents the context of that artifact.
 */
public interface ProfilingProducerScope {

  /**
   * @return the identifier for the ProfilingProducerScope associated to an instance of {@link ProfilingDataProducer}
   */
  String getProducerScopeIdentifier();

  /**
   * @return the scope type for the producer scope. For example, if we to be able to retrieve {@link ProfilingDataProducer}
   *         associated to an artifact, this identifier should represent that level of granularity (the data will be bound to
   *         application A but not application B, for example).
   */
  ProfilingProducerScopeType getProducerScopeTypeIdentifier();
}
