/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.tracing;

import org.mule.runtime.api.message.Error;

/**
 * Represents an error that occurred during the execution of the work that a {@link Span} represents.
 */
public interface SpanError {

  /**
   * @return The {@link Error} that occurred.
   */
  Error getError();

  /**
   * @return True if the error is not being handled as part of the execution of the work that the {@link Span} containing the
   *         error represents.
   */
  boolean isEscapingSpan();

}
