/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.type;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.context.ByteBufferProviderEventContext;
import org.mule.runtime.api.scheduler.Scheduler;

/**
 * A {@link ProfilingEventType} that represents alloc/dealloc operations. A {@link ProfilingDataConsumer} can be created to
 * consume the data associated to these profiling events.
 *
 * @see ProfilingEventType
 * @see ProfilingDataConsumer
 * @see Scheduler
 * @since 1.1
 */
@Experimental
@NoInstantiate
public class ByteBufferAllocationEventType implements ProfilingEventType<ByteBufferProviderEventContext> {

  private final String profilingEventTypeIdentifier;
  private final String profilingEventTypeNamespace;

  public ByteBufferAllocationEventType(String profilingEventTypeIdentifier, String profilingEventTypeNamespace) {
    this.profilingEventTypeIdentifier = profilingEventTypeIdentifier;
    this.profilingEventTypeNamespace = profilingEventTypeNamespace;
  }

  @Override
  public String getProfilingEventTypeIdentifier() {
    return profilingEventTypeIdentifier;
  }

  @Override
  public String getProfilingEventTypeNamespace() {
    return profilingEventTypeNamespace;
  }
}
