/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.type.context;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.profiling.ProfilingEventContext;

/**
 * Context information for a memory management alloc/dealloc opration.
 *
 * @since 1.1.0
 */
@NoImplement
@Experimental
public interface ByteBufferProviderEventContext extends ProfilingEventContext {

  /**
   * indicates the name of the ByteBufferProvider involved in the event.
   * 
   * @return
   */
  String getByteBufferProviderName();

  /**
   * The size of the chunk of memory involved in the operation.
   *
   * @return
   */
  int size();

}
