/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.tracing;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;

import java.util.Optional;

/**
 * Context that contains data about the runtime execution status.
 */
@NoImplement
@Experimental
public interface ExecutionContext {

  /**
   * @return {@link ComponentMetadata} about the current {@link org.mule.runtime.api.component.execution.ExecutableComponent}.
   *         Current means that the code invoking this method is inside the scope of such component's execution.
   */
  Optional<ComponentMetadata> getCurrentComponentMetadata();

}
