/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.tracing;

import java.util.Set;

/**
 * Span represents a unit of work and a time it takes.
 *
 * @since 1.0.1
 */
public interface Span {

  /**
   * @return The {@link Span} that caused the current Span existence (can be null).
   */
  Span getParent();

  /**
   * @return A non-constrained identifier for this {@link Span}.
   * @see #getName()
   */
  SpanIdentifier getIdentifier();

  /**
   * @return The name of the {@link Span}. The span name concisely identifies the work represented by the Span. The span name
   *         SHOULD be the most general string that identifies a (statistically) interesting class of Spans, rather than
   *         individual Span instances while still being human-readable.
   */
  String getName();

  /**
   * @return The duration for this {@link Span}.
   */
  SpanDuration getDuration();

  /**
   * @return Any error that occurred during the execution of the work that the {@link Span} represents.
   */
  Set<SpanError> getErrors();

  /**
   * @return True if at least one error occurred during the execution of the work that the {@link Span} represents.
   * @see #getErrors()
   */
  boolean hasErrors();

}
