/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.type.context;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.tracing.ExecutionContext;
import org.mule.runtime.api.profiling.type.TaskSchedulingProfilingEventType;

import java.util.Optional;

/**
 * {@link ProfilingEventContext} for {@link TaskSchedulingProfilingEventType}. Contains relevant data about task scheduling, plus
 * an {@link ExecutionContext} that allows correlation with other profiling events.
 */
@NoImplement
@Experimental
public interface TaskSchedulingProfilingEventContext extends ProfilingEventContext {

  /**
   * @return The thread where the described event took place.
   */
  String getThreadName();

  /**
   * @return The id of the scheduled task.
   */
  String getTaskId();

  /**
   * @return The {@link ExecutionContext} where the described event took place.
   */
  Optional<ExecutionContext> getTaskTracingContext();

}
