/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.tracing;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;

import java.util.Optional;

/**
 * Defines the tracing metadata for an {@link org.mule.runtime.api.component.execution.ExecutableComponent}.
 */
@NoImplement
@Experimental
public interface ComponentMetadata {

  /**
   * @return The correlation id of the {@link Event} that the component is processing.
   * @see Event#getCorrelationId()
   */
  String getCorrelationId();

  /**
   * @return The mule artifact id that the component is part of.
   */
  String getArtifactId();

  /**
   * @return The mule artifact type that the component is part of.
   */
  String getArtifactType();

  /**
   * @return The component's {@link ComponentLocation}.
   */
  Optional<ComponentLocation> getComponentLocation();

}
