/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.type;

import org.mule.runtime.api.profiling.type.context.SpanProfilingEventContext;

/**
 * A {@link ProfilingEventType} that indicates that a span should be created. A Span represents both a unit of work and the time
 * it took to happen. The {@link org.mule.runtime.api.profiling.ProfilingDataConsumer} that listen to this events are responsible
 * for handling and matching the start and end of this profiling events.
 *
 * @since 1.0.1
 */
public class SpanStartProfilingEventType
    implements ProfilingEventType<SpanProfilingEventContext> {

  private final String profilingEventTypeIdentifier;
  private final String profilingEventTypeNamespace;

  public SpanStartProfilingEventType(String profilingEventTypeIdentifier, String profilingEventTypeNamespace) {
    this.profilingEventTypeIdentifier = profilingEventTypeIdentifier;
    this.profilingEventTypeNamespace = profilingEventTypeNamespace;
  }

  @Override
  public String getProfilingEventTypeIdentifier() {
    return profilingEventTypeIdentifier;
  }

  @Override
  public String getProfilingEventTypeNamespace() {
    return profilingEventTypeNamespace;
  }
}
