/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.threading;

/**
 * Interface used to collect a {@link ThreadSnapshot}.
 *
 * @see ThreadSnapshot
 */
public interface ThreadSnapshotCollector {

  /**
   * Collects a {@link ThreadSnapshot}.
   *
   * @return a new {@link ThreadSnapshot}.
   */
  ThreadSnapshot getCurrentThreadSnapshot();

}
