/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.type.context;

import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.tracing.Span;

/**
 * A {@link ProfilingEventContext} with information about spans. A Span is a unit of work and represents at the most basic level
 * the time it took
 *
 * @since 1.0.1
 */
public interface SpanProfilingEventContext extends ProfilingEventContext {

  Span getSpan();

}
