/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.tracing;

/**
 * An identifier for the {@link Span}
 */
public interface SpanIdentifier {

  String INVALID_SPAN_ID = "0000000000000000";
  String INVALID_TRACE_ID = "0000000000000000";

  SpanIdentifier INVALID_SPAN_IDENTIFIER = new SpanIdentifier() {

    @Override
    public String getId() {
      return INVALID_SPAN_ID;
    }

    @Override
    public String getTraceId() {
      return INVALID_TRACE_ID;
    }
  };

  /**
   * @return the id for the {@link Span}
   */
  String getId();

  /**
   * @return the id for the global span.
   */
  String getTraceId();

  default boolean isValid() {
    return INVALID_SPAN_IDENTIFIER != this;
  }

}
