/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.properties.internal;

import static java.util.Objects.requireNonNull;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;

public class ConfigurationPropertiesException extends MuleRuntimeException implements ComponentProvider {

  private static final long serialVersionUID = 7238507825104512841L;

  private final Component component;

  public ConfigurationPropertiesException(I18nMessage message, Component component) {
    super(message);
    this.component = requireNonNull(component, "component cannot be null");
  }

  public ConfigurationPropertiesException(I18nMessage message, Component component, Exception e) {
    super(message, e);
    this.component = requireNonNull(component, "component cannot be null");
  }

  @Override
  public Component getComponent() {
    return component;
  }
}
