/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.properties.internal;

import static java.util.Objects.requireNonNull;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.properties.api.ConfigurationProperty;

/**
 * Represents a configuration attribute.
 *
 * @since 1.0
 */
public class DefaultConfigurationProperty implements ConfigurationProperty {

  private final Object source;
  private final String rawValue;
  private final String key;

  /**
   * Creates a new configuration value
   *
   * @param source   the source of this configuration attribute. For instance, it may be an {@link Component} if it's source was
   *                 defined in the artifact configuration or it may be the deployment properties configured at deployment time.
   * @param key      the key of the configuration attribute to reference it.
   * @param rawValue the plain configuration value without resolution. A configuration value may contain reference to other
   *                 configuration attributes.
   */
  public DefaultConfigurationProperty(Object source, String key, String rawValue) {
    this.source = requireNonNull(source, "source cannot be null");
    this.rawValue = requireNonNull(rawValue, "rawValue cannot be null");
    this.key = requireNonNull(key, "key cannot be null");
  }


  @Override
  public Object getSource() {
    return source;
  }

  @Override
  public String getValue() {
    return rawValue;
  }

  @Override
  public String getKey() {
    return key;
  }

  @Override
  public String toString() {
    return getKey() + ": '" + getValue() + "'";
  }

}
