/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.properties.api;

import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;

import java.util.Optional;

/**
 * A provider of configuration attributes.
 * <p>
 * Configuration attributes must be provided upon request since there may be implementations of this interface that do not have a
 * small number of configuration attributes and doing a lookup of the attributes may not be trivial. Such would be the case of a
 * vault implementation of this interface which will probably lookup for values from a remote entity.
 * <p>
 * Implementations may also implement {@link Initialisable} and/or {@link Disposable} to create, keep and destroy any context that
 * is required to properly resolve the properties.
 *
 * @since 1.0
 */
public interface ConfigurationPropertiesProvider {

  /**
   * @param configurationAttributeKey the key of the configuration attribute.
   * @return the {@link ConfigurationProperty} associated with the key. May be empty if that key is not present.
   */
  Optional<? extends ConfigurationProperty> provide(String configurationAttributeKey);

  /**
   * @return a meaningful description of the provider. This is used for error reporting.
   */
  String getDescription();

}
