/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * Module with the API to provide custom property placeholder resolvers for Mule Artifacts.
 *
 * @moduleGraph
 * @since 1.2
 */
module org.mule.runtime.properties.api {

  requires org.mule.runtime.api;
  requires org.mule.runtime.artifact.ast;

  exports org.mule.runtime.properties.api;

  uses org.mule.runtime.properties.api.ConfigurationPropertiesProviderFactory;
  uses org.mule.runtime.properties.api.DefaultConfigurationPropertiesProviderFactory;

  exports org.mule.runtime.properties.internal to
      org.mule.runtime.properties.config,
      org.mule.runtime.spring.config;
  exports org.mule.runtime.properties.internal.loader to
      org.mule.runtime.properties.config;
}