/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.properties.api;

import org.mule.api.annotation.NoImplement;

import java.io.InputStream;
import java.nio.file.Path;

/**
 * Represents a generic resource provider, to be used instead of the artifact class loader.
 *
 * @since 1.0
 */
@NoImplement
public interface ResourceProvider {

  /**
   * @param resourceName location of the resource. It may be a classpath location or an absolute path.
   * @return the input stream of the resource or null if the resource was not found.
   */
  InputStream getResourceAsStream(String resourceName);

  /**
   * @param resourceName location of the resource. It may be a classpath location or an absolute path.
   * @return the absolute path of the resource or null if the resource was not found.
   * @since 4.11
   */
  Path getResourceAsPath(String resourceName);

}
