/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class ErrorMappingTargetTypeReferencesExist
extends AbstractErrorTypesValidation {
    public ErrorMappingTargetTypeReferencesExist(Optional<FeatureFlaggingService> featureFlaggingService, boolean ignoreParamsWithProperties) {
        super(featureFlaggingService, ignoreParamsWithProperties);
    }

    public String getName() {
        return "Error Type references exist";
    }

    public String getDescription() {
        return "Referenced error types do exist in the context of the artifact.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(((Predicate<ComponentAst>)this::errorMappingPresent).and(comp -> this.isIgnoreParamsWithProperties() ? this.errorMappingTargetNotPropertyDependant((ComponentAst)comp) : true));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        Set errorNamespaces = artifact.dependencies().stream().map(d -> d.getXmlDslModel().getPrefix().toUpperCase()).collect(Collectors.toSet());
        for (ErrorMapping errorMapping : ErrorMappingTargetTypeReferencesExist.getErrorMappings(component)) {
            String errorTypeString = errorMapping.getTarget();
            ComponentIdentifier errorTypeId = ErrorMappingTargetTypeReferencesExist.parseErrorType(errorTypeString);
            if (errorNamespaces.contains(errorTypeId.getNamespace())) {
                return ErrorMappingTargetTypeReferencesExist.validateErrorTypeId(component, component.getParameter("Error Mappings", "errorMappings"), artifact, this, errorMapping.getTarget(), errorTypeId);
            }
            if (!artifact.getParent().map(p -> p.getErrorTypeRepository().getErrorNamespaces().contains(errorTypeId.getNamespace())).orElse(false).booleanValue()) continue;
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)component.getParameter("Error Mappings", "errorMappings"), (Validation)this, (String)String.format("Cannot use error type '%s': namespace already exists.", errorMapping.getTarget())));
        }
        return Optional.empty();
    }
}

