/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.IntAnnotation;
import org.mule.metadata.api.annotation.NumberRangeAnnotation;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.ParameterResolutionException;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class NumberParameterWithinRange
implements Validation {
    private final boolean ignoreParamsWithProperties;

    public NumberParameterWithinRange(boolean ignoreParamsWithProperties) {
        this.ignoreParamsWithProperties = ignoreParamsWithProperties;
    }

    public String getName() {
        return "Number parameter within range.";
    }

    public String getDescription() {
        return "Value of a Number type parameter is within the defined range.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(comp -> comp.getModel(ParameterizedModel.class).map(pmzd -> ExtensionModelUtils.getGroupAndParametersPairs((ParameterizedModel)pmzd).anyMatch(groupAndParameter -> this.isDoValidation((ParameterModel)groupAndParameter.getSecond(), comp.getParameter(((ParameterGroupModel)groupAndParameter.getFirst()).getName(), ((ParameterModel)groupAndParameter.getSecond()).getName())))).orElse(false));
    }

    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return component.getModel(ParameterizedModel.class).map(pmzd -> ExtensionModelUtils.getGroupAndParametersPairs((ParameterizedModel)pmzd).map(groupAndParameter -> new Pair((Object)((ParameterModel)groupAndParameter.getSecond()), (Object)component.getParameter(((ParameterGroupModel)groupAndParameter.getFirst()).getName(), ((ParameterModel)groupAndParameter.getSecond()).getName()))).filter(modelAndParam -> this.isDoValidation((ParameterModel)modelAndParam.getFirst(), (ComponentParameterAst)modelAndParam.getSecond()))).orElse(Stream.empty()).map(param -> {
            if (this.numberOffRange((ParameterModel)param.getFirst(), (ComponentParameterAst)param.getSecond())) {
                return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)((ComponentParameterAst)param.getSecond()), (Validation)this, (String)String.format("Parameter '%s' in element <%s> value '%s' is not within expected range.", ((ParameterModel)param.getFirst()).getName(), component.getIdentifier().toString(), ((ComponentParameterAst)param.getSecond()).getResolvedRawValue())));
            }
            if (((ComponentParameterAst)param.getSecond()).getValueOrResolutionError().isRight() && ((Either)((ComponentParameterAst)param.getSecond()).getValueOrResolutionError().getRight()).getRight() instanceof ComponentAst) {
                return this.validate((ComponentAst)((Either)((ComponentParameterAst)param.getSecond()).getValueOrResolutionError().getRight()).getRight(), artifact);
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private boolean numberOffRange(ParameterModel paramModel, ComponentParameterAst paramAst) {
        Optional value = paramAst.getValueOrResolutionError().getValue();
        if (paramAst == null || !value.isPresent()) {
            return false;
        }
        NumberWithinRangeVisitor visitor = new NumberWithinRangeVisitor(value);
        paramModel.getType().accept((MetadataTypeVisitor)visitor);
        return visitor.isValueOffRange();
    }

    protected boolean isDoValidation(ParameterModel pm, ComponentParameterAst componentParameterAst) {
        if (this.ignoreParamsWithProperties && MuleAstUtils.hasPropertyPlaceholder((String)componentParameterAst.getRawValue())) {
            return false;
        }
        NumberHasRangeVisitor visitor = new NumberHasRangeVisitor();
        pm.getType().accept((MetadataTypeVisitor)visitor);
        return visitor.hasRangeAnnotation();
    }

    private static final class NumberWithinRangeVisitor
    extends MetadataTypeVisitor {
        private final Optional<Either<ParameterResolutionException, Number>> value;
        private boolean valueOffRange = true;

        private NumberWithinRangeVisitor(Optional<Either<ParameterResolutionException, Number>> value) {
            this.value = value;
        }

        public boolean isValueOffRange() {
            return this.valueOffRange;
        }

        public void visitNumber(NumberType numberType) {
            NumberRangeAnnotation rangeAnnotation = (NumberRangeAnnotation)numberType.getAnnotation(NumberRangeAnnotation.class).get();
            Number valueAsNumber = (Number)this.value.get().getRight();
            if (numberType.getAnnotation(IntAnnotation.class).isPresent()) {
                rangeAnnotation.getFrom().map(from -> valueAsNumber.longValue() < from.longValue()).ifPresent(v -> {
                    this.valueOffRange = v;
                });
                rangeAnnotation.getTo().map(to -> valueAsNumber.longValue() > to.longValue()).ifPresent(v -> {
                    this.valueOffRange = v;
                });
            } else {
                rangeAnnotation.getFrom().map(from -> valueAsNumber.doubleValue() < from.doubleValue()).ifPresent(v -> {
                    this.valueOffRange = v;
                });
                rangeAnnotation.getTo().map(to -> valueAsNumber.doubleValue() > to.doubleValue()).ifPresent(v -> {
                    this.valueOffRange = v;
                });
            }
        }
    }

    private static final class NumberHasRangeVisitor
    extends MetadataTypeVisitor {
        private boolean rangeAnnotation = false;

        private NumberHasRangeVisitor() {
        }

        public void visitNumber(NumberType numberType) {
            this.rangeAnnotation = numberType.getAnnotation(NumberRangeAnnotation.class).isPresent();
        }

        public boolean hasRangeAnnotation() {
            return this.rangeAnnotation;
        }
    }
}

