/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class FlowRefPointsToExistingFlow
implements Validation {
    private static final String FLOW_REF_ELEMENT = "flow-ref";
    private static final String DEFAULT_EXPRESSION_PREFIX = "#[";
    private static final String DEFAULT_EXPRESSION_SUFFIX = "]";
    private static final ComponentIdentifier FLOW_REF_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("flow-ref").build();

    public String getName() {
        return "'flow-ref's point to existing flows";
    }

    public String getDescription() {
        return "'flow-ref's point to existing flows.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement((Predicate)ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)FLOW_REF_IDENTIFIER)).and(ComponentAstPredicatesFactory.currentElemement(componentModel -> componentModel.getParameter("General", "name").getValue().isRight()));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst param = component.getParameter("General", "name");
        return (Optional)param.getValue().reduce(l -> Optional.empty(), nameAttribute -> {
            if (((String)nameAttribute).startsWith(DEFAULT_EXPRESSION_PREFIX) && ((String)nameAttribute).endsWith(DEFAULT_EXPRESSION_SUFFIX)) {
                return Optional.empty();
            }
            if (artifact.topLevelComponentsStream().noneMatch(ComponentAstPredicatesFactory.equalsComponentId((String)((String)nameAttribute)))) {
                return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)param, (Validation)this, (String)("'flow-ref' is pointing to '" + nameAttribute + "' which does not exist")));
            }
            return Optional.empty();
        });
    }
}

