/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class OperationRaiseErrorDoesntSpecifyNamespace
implements Validation {
    private static final char NAMESPACE_IDENTIFIER_SEPARATOR = ':';
    private static final String OPERATION_PREFIX = "operation";
    private static final String RAISE_ERROR = "raise-error";
    private static final ComponentIdentifier OPERATION_RAISE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("operation").name("raise-error").build();

    public String getName() {
        return "Operation raise error doesn't specify namespace";
    }

    public String getDescription() {
        return "Operation raise error doesn't specify namespace.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement((Predicate)ComponentAstPredicatesFactory.equalsIdentifier((ComponentIdentifier)OPERATION_RAISE_ERROR_IDENTIFIER));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst errorTypeParam = OperationRaiseErrorDoesntSpecifyNamespace.getErrorTypeParam(component);
        String errorTypeString = errorTypeParam.getResolvedRawValue();
        int indexOfSeparator = errorTypeString.indexOf(58);
        if (indexOfSeparator != -1) {
            String namespace = errorTypeString.substring(0, indexOfSeparator);
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)errorTypeParam, (Validation)this, (String)String.format("Operation raise error component (%s) is not allowed to specify a namespace: '%s'", OPERATION_RAISE_ERROR_IDENTIFIER, namespace)));
        }
        return Optional.empty();
    }

    private static ComponentParameterAst getErrorTypeParam(ComponentAst component) {
        return component.getParameter("General", "type");
    }
}

