/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.validation.Severity;
import org.mule.runtime.ast.api.validation.ArtifactValidation;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationsProvider;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphProvider;
import org.mule.runtime.config.internal.validation.AllComponentsBelongToSomeExtensionModel;
import org.mule.runtime.config.internal.validation.ConfigReferenceParametersNonPropertyValueValidations;
import org.mule.runtime.config.internal.validation.ConfigReferenceParametersStereotypesValidations;
import org.mule.runtime.config.internal.validation.DefaultArtifactAstDependencyGraphProvider;
import org.mule.runtime.config.internal.validation.DynamicConfigWithStatefulOperationConfigurationOverride;
import org.mule.runtime.config.internal.validation.ErrorHandlerOnErrorHasTypeOrWhen;
import org.mule.runtime.config.internal.validation.ErrorHandlerOnErrorTypeExists;
import org.mule.runtime.config.internal.validation.ErrorHandlerOnErrorTypeNonPropertyValue;
import org.mule.runtime.config.internal.validation.ErrorMappingSourceTypeReferencesExist;
import org.mule.runtime.config.internal.validation.ErrorMappingSourceTypeReferencesNonPropertyValue;
import org.mule.runtime.config.internal.validation.ErrorMappingTargetTypeReferencesDoNotUseExtensionNamespace;
import org.mule.runtime.config.internal.validation.ErrorMappingTargetTypeReferencesExist;
import org.mule.runtime.config.internal.validation.ErrorMappingTargetTypeReferencesNonPropertyValue;
import org.mule.runtime.config.internal.validation.ExpressionParametersNotUsingMel;
import org.mule.runtime.config.internal.validation.ExpressionParametersSyntacticallyValid;
import org.mule.runtime.config.internal.validation.ExpressionsInRequiredExpressionsParams;
import org.mule.runtime.config.internal.validation.ExpressionsInRequiredExpressionsParamsNonPropertyValue;
import org.mule.runtime.config.internal.validation.FirstSuccessfulRoutes;
import org.mule.runtime.config.internal.validation.FlowRefPointsToExistingFlow;
import org.mule.runtime.config.internal.validation.FlowRefPointsToNonPropertyValue;
import org.mule.runtime.config.internal.validation.ImportValidTarget;
import org.mule.runtime.config.internal.validation.InsecureTLSValidation;
import org.mule.runtime.config.internal.validation.MelNotEnabled;
import org.mule.runtime.config.internal.validation.MuleSdkOperationDoesNotHaveForbiddenFunctionsInExpressions;
import org.mule.runtime.config.internal.validation.NameHasValidCharacters;
import org.mule.runtime.config.internal.validation.NameIsNotRepeated;
import org.mule.runtime.config.internal.validation.NamedTopLevelElementsHaveName;
import org.mule.runtime.config.internal.validation.NoExpressionsInNoExpressionsSupportedParams;
import org.mule.runtime.config.internal.validation.NumberParameterWithinRange;
import org.mule.runtime.config.internal.validation.OperationDoesNotHaveApikitConsole;
import org.mule.runtime.config.internal.validation.OperationDoesNotHaveApikitRouter;
import org.mule.runtime.config.internal.validation.OperationDoesNotHaveCoreRaiseError;
import org.mule.runtime.config.internal.validation.OperationDoesNotHaveFlowRef;
import org.mule.runtime.config.internal.validation.OperationErrorHandlersDoNotReferGlobalErrorHandlers;
import org.mule.runtime.config.internal.validation.OperationParameterDefaultValueDoesntSupportExpressions;
import org.mule.runtime.config.internal.validation.OperationRaiseErrorDoesntSpecifyNamespace;
import org.mule.runtime.config.internal.validation.ParameterGroupExclusiveness;
import org.mule.runtime.config.internal.validation.ParseTemplateResourceExist;
import org.mule.runtime.config.internal.validation.ParseTemplateResourceNotPropertyValue;
import org.mule.runtime.config.internal.validation.PollingSourceHasSchedulingStrategy;
import org.mule.runtime.config.internal.validation.RaiseErrorReferenceDoNotUseExtensionNamespaces;
import org.mule.runtime.config.internal.validation.RaiseErrorTypeReferencesExist;
import org.mule.runtime.config.internal.validation.RaiseErrorTypeReferencesNonPropertyValue;
import org.mule.runtime.config.internal.validation.RaiseErrorTypeReferencesPresent;
import org.mule.runtime.config.internal.validation.ReferenceParametersStereotypesValidations;
import org.mule.runtime.config.internal.validation.RequiredParametersPresent;
import org.mule.runtime.config.internal.validation.RoundRobinRoutes;
import org.mule.runtime.config.internal.validation.ScatterGatherRoutes;
import org.mule.runtime.config.internal.validation.SingletonsAreNotRepeated;
import org.mule.runtime.config.internal.validation.SingletonsPerFileAreNotRepeated;
import org.mule.runtime.config.internal.validation.SourceErrorMappingAnyLast;
import org.mule.runtime.config.internal.validation.SourceErrorMappingAnyNotRepeated;
import org.mule.runtime.config.internal.validation.SourceErrorMappingTypeNotRepeated;
import org.mule.runtime.config.internal.validation.SourcePositiveMaxItemsPerPoll;
import org.mule.runtime.config.internal.validation.ast.ArtifactAstGraphDependencyProviderAware;

public class CoreValidationsProvider
implements ValidationsProvider,
ArtifactAstGraphDependencyProviderAware {
    private ClassLoader artifactRegionClassLoader;
    private boolean ignoreParamsWithProperties;
    @Inject
    private Optional<ArtifactAstDependencyGraphProvider> artifactAstDependencyGraphProvider = Optional.empty();
    @Inject
    private Optional<FeatureFlaggingService> featureFlaggingService = Optional.empty();
    @Inject
    private ExpressionLanguage expressionLanguage;
    @Inject
    @Named(value="_compatibilityPluginInstalled")
    private Optional<Object> compatibilityPluginInstalled;

    public List<Validation> get() {
        ArrayList<Validation> validations = new ArrayList<Validation>(Arrays.asList(new AllComponentsBelongToSomeExtensionModel(this.isCompatibilityInstalled()), new SingletonsAreNotRepeated(), new SingletonsPerFileAreNotRepeated(), new NamedTopLevelElementsHaveName(), new NameHasValidCharacters(), new NameIsNotRepeated(), new FlowRefPointsToNonPropertyValue(), new FlowRefPointsToExistingFlow(this.ignoreParamsWithProperties), new SourceErrorMappingAnyNotRepeated(), new SourceErrorMappingAnyLast(), new SourceErrorMappingTypeNotRepeated(), new ErrorHandlerOnErrorHasTypeOrWhen(), new RaiseErrorTypeReferencesPresent(this.featureFlaggingService), new RaiseErrorReferenceDoNotUseExtensionNamespaces(this.featureFlaggingService), new RaiseErrorTypeReferencesNonPropertyValue(), new RaiseErrorTypeReferencesExist(this.featureFlaggingService, this.ignoreParamsWithProperties), new ErrorMappingTargetTypeReferencesNonPropertyValue(), new ErrorMappingTargetTypeReferencesExist(this.featureFlaggingService, this.ignoreParamsWithProperties), new ErrorMappingTargetTypeReferencesDoNotUseExtensionNamespace(this.featureFlaggingService, this.ignoreParamsWithProperties), new ErrorMappingSourceTypeReferencesNonPropertyValue(), new ErrorMappingSourceTypeReferencesExist(this.featureFlaggingService, this.ignoreParamsWithProperties), new ErrorHandlerOnErrorTypeNonPropertyValue(), new ErrorHandlerOnErrorTypeExists(this.featureFlaggingService, this.ignoreParamsWithProperties), new RequiredParametersPresent(), new ParameterGroupExclusiveness(), new NumberParameterWithinRange(this.ignoreParamsWithProperties), new OperationErrorHandlersDoNotReferGlobalErrorHandlers(), new ExpressionsInRequiredExpressionsParamsNonPropertyValue(), new ExpressionsInRequiredExpressionsParams(this.featureFlaggingService, this.ignoreParamsWithProperties), new OperationParameterDefaultValueDoesntSupportExpressions(), new NoExpressionsInNoExpressionsSupportedParams(), new DynamicConfigWithStatefulOperationConfigurationOverride(), new PollingSourceHasSchedulingStrategy(), new RoundRobinRoutes(), new FirstSuccessfulRoutes(), new ScatterGatherRoutes(), new ParseTemplateResourceNotPropertyValue(this.ignoreParamsWithProperties), new ParseTemplateResourceExist(this.artifactRegionClassLoader, this.ignoreParamsWithProperties), new SourcePositiveMaxItemsPerPoll(), new OperationRaiseErrorDoesntSpecifyNamespace(), new OperationDoesNotHaveCoreRaiseError(), new OperationDoesNotHaveFlowRef(), new OperationDoesNotHaveApikitRouter(), new OperationDoesNotHaveApikitConsole(), new InsecureTLSValidation()));
        validations.add(new ExpressionParametersNotUsingMel());
        if (this.expressionLanguage != null) {
            validations.add(new ExpressionParametersSyntacticallyValid(this.expressionLanguage, () -> CoreValidationsProvider.getExpressionSyntacticValidationErrorLevel(this.featureFlaggingService), Severity.ERROR));
            validations.add(new ExpressionParametersSyntacticallyValid(this.expressionLanguage, () -> Validation.Level.WARN, Severity.WARNING));
            validations.add(new MuleSdkOperationDoesNotHaveForbiddenFunctionsInExpressions(this.expressionLanguage));
        }
        return validations;
    }

    private boolean isCompatibilityInstalled() {
        return this.compatibilityPluginInstalled != null && this.compatibilityPluginInstalled.isPresent();
    }

    public static Validation.Level getExpressionSyntacticValidationErrorLevel(Optional<FeatureFlaggingService> featureFlaggingService) {
        boolean validateExpressions = true;
        String validateExpressionsPropValue = System.getProperty("mule.validate.expressions");
        if (validateExpressionsPropValue != null) {
            validateExpressions = Boolean.valueOf(validateExpressionsPropValue);
        }
        return validateExpressions && featureFlaggingService.map(ffs -> ffs.isEnabled((Feature)MuleRuntimeFeature.ENFORCE_EXPRESSION_VALIDATION)).orElse(true) != false ? Validation.Level.ERROR : Validation.Level.WARN;
    }

    public List<ArtifactValidation> getArtifactValidations() {
        ArtifactAstDependencyGraphProvider artifactAstDependencyGraphProviderForValidator = this.artifactAstDependencyGraphProvider.orElse(new DefaultArtifactAstDependencyGraphProvider());
        return Arrays.asList(new ImportValidTarget(), new ConfigReferenceParametersNonPropertyValueValidations(artifactAstDependencyGraphProviderForValidator), new ConfigReferenceParametersStereotypesValidations(this.featureFlaggingService, this.ignoreParamsWithProperties, artifactAstDependencyGraphProviderForValidator), new ReferenceParametersStereotypesValidations(artifactAstDependencyGraphProviderForValidator), new MelNotEnabled(this.isCompatibilityInstalled()));
    }

    public void setArtifactRegionClassLoader(ClassLoader artifactRegionClassLoader) {
        this.artifactRegionClassLoader = artifactRegionClassLoader;
    }

    public void setIgnoreParamsWithProperties(boolean ignoreParamsWithProperties) {
        this.ignoreParamsWithProperties = ignoreParamsWithProperties;
    }

    @Override
    public void setArtifactAstDependencyGraphProvider(ArtifactAstDependencyGraphProvider artifactAstDependencyGraphProvider) {
        this.artifactAstDependencyGraphProvider = Optional.of(artifactAstDependencyGraphProvider);
    }
}

