/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.api.tcp;

import org.mule.service.http.api.tcp.DefaultTcpClientSocketProperties;
import org.mule.service.http.api.tcp.TcpClientSocketProperties;

public final class TcpClientSocketPropertiesBuilder {
    protected Integer sendBufferSize;
    protected Integer receiveBufferSize;
    protected Integer clientTimeout;
    protected Boolean sendTcpNoDelay = true;
    protected Integer linger;
    protected Boolean keepAlive = false;
    private Integer connectionTimeout = 30000;

    TcpClientSocketPropertiesBuilder() {
    }

    public TcpClientSocketPropertiesBuilder setSendBufferSize(Integer sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
        return this;
    }

    public TcpClientSocketPropertiesBuilder setReceiveBufferSize(Integer receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        return this;
    }

    public TcpClientSocketPropertiesBuilder setClientTimeout(Integer clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    public TcpClientSocketPropertiesBuilder setSendTcpNoDelay(Boolean sendTcpNoDelay) {
        this.sendTcpNoDelay = sendTcpNoDelay;
        return this;
    }

    public TcpClientSocketPropertiesBuilder setLinger(Integer linger) {
        this.linger = linger;
        return this;
    }

    public TcpClientSocketPropertiesBuilder setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public TcpClientSocketPropertiesBuilder setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public TcpClientSocketProperties build() {
        return new DefaultTcpClientSocketProperties(this.sendBufferSize, this.receiveBufferSize, this.clientTimeout, this.sendTcpNoDelay, this.linger, this.keepAlive, this.connectionTimeout);
    }
}

