/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import sun.misc.IOUtils;

public class InputStreamHttpEntity
implements HttpEntity {
    private Integer contentLength;
    private InputStream inputStream;

    public InputStreamHttpEntity(InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream, (String)"HTTP entity stream cannot be null.");
        this.inputStream = inputStream;
    }

    public InputStreamHttpEntity(Integer contentLength, InputStream inputStream) {
        this(inputStream);
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public boolean hasContentLength() {
        return this.contentLength != null;
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public boolean isComposed() {
        return false;
    }

    @Override
    public InputStream getContent() {
        return this.inputStream;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return IOUtils.readFully((InputStream)this.inputStream, (int)-1, (boolean)true);
    }

    @Override
    public Collection<HttpPart> getParts() {
        return Collections.emptyList();
    }
}

