/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.ws;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.annotation.Experimental;

@Experimental
public enum WebSocketCloseCode {
    NORMAL_CLOSURE(1000),
    ENDPOINT_GOING_DOWN(1001),
    PROTOCOL_ERROR(1002),
    INVALID_DATA(1003),
    MESSAGE_TOO_LARGE(1004);

    private static final Map<Integer, WebSocketCloseCode> CODES;
    private final int protocolCode;

    public static WebSocketCloseCode fromProtocolCode(int protocolCode) {
        WebSocketCloseCode code = CODES.get(protocolCode);
        if (code == null) {
            throw new IllegalArgumentException("Invalid protocol code " + protocolCode);
        }
        return code;
    }

    private WebSocketCloseCode(int protocolCode) {
        this.protocolCode = protocolCode;
    }

    public int getProtocolCode() {
        return this.protocolCode;
    }

    static {
        CODES = new HashMap<Integer, WebSocketCloseCode>(WebSocketCloseCode.values().length);
        for (WebSocketCloseCode code : WebSocketCloseCode.values()) {
            CODES.put(code.protocolCode, code);
        }
    }
}

