/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client;

import org.mule.api.annotation.Experimental;
import org.mule.runtime.http.api.client.DefaultHttpRequestOptions;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

@Experimental
public final class HttpRequestOptionsBuilder {
    private int responseTimeout = 30000;
    private boolean followsRedirect = true;
    private HttpAuthentication authentication;
    private Boolean streamResponse;
    private ProxyConfig proxyConfig;
    private Integer responseBufferSize;

    HttpRequestOptionsBuilder() {
    }

    HttpRequestOptionsBuilder(HttpRequestOptions options) {
        this.responseTimeout = options.getResponseTimeout();
        this.followsRedirect = options.isFollowsRedirect();
        this.authentication = options.getAuthentication().orElse(null);
        this.streamResponse = options.isStreamResponse().orElse(null);
        this.responseBufferSize = options.getResponseBufferSize().orElse(null);
        this.proxyConfig = options.getProxyConfig().orElse(null);
    }

    public HttpRequestOptionsBuilder responseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public HttpRequestOptionsBuilder followsRedirect(boolean followsRedirect) {
        this.followsRedirect = followsRedirect;
        return this;
    }

    public HttpRequestOptionsBuilder authentication(HttpAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public HttpRequestOptionsBuilder streamResponse(boolean streamResponse) {
        this.streamResponse = streamResponse;
        return this;
    }

    public HttpRequestOptionsBuilder responseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
        return this;
    }

    public HttpRequestOptionsBuilder proxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this;
    }

    public HttpRequestOptions build() {
        return new DefaultHttpRequestOptions(this.responseTimeout, this.followsRedirect, this.authentication, this.streamResponse, this.responseBufferSize, this.proxyConfig);
    }
}

