/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.sse.client.SseRetryConfig;
import org.mule.runtime.http.api.sse.client.SseSource;
import org.mule.runtime.http.api.ws.WebSocket;

@NoImplement
public interface HttpClient {
    public void start();

    public void stop();

    @Deprecated
    default public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) throws IOException, TimeoutException {
        return this.send(request, HttpRequestOptions.builder().responseTimeout(responseTimeout).followsRedirect(followRedirects).authentication(authentication).build());
    }

    default public HttpResponse send(HttpRequest request) throws IOException, TimeoutException {
        return this.send(request, HttpRequestOptions.builder().build());
    }

    public HttpResponse send(HttpRequest var1, HttpRequestOptions var2) throws IOException, TimeoutException;

    @Deprecated
    default public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) {
        return this.sendAsync(request, HttpRequestOptions.builder().responseTimeout(responseTimeout).followsRedirect(followRedirects).authentication(authentication).build());
    }

    default public CompletableFuture<HttpResponse> sendAsync(HttpRequest request) {
        return this.sendAsync(request, HttpRequestOptions.builder().build());
    }

    public CompletableFuture<HttpResponse> sendAsync(HttpRequest var1, HttpRequestOptions var2);

    default public CompletableFuture<WebSocket> openWebSocket(HttpRequest request, String socketId, WebSocketCallback callback) {
        return this.openWebSocket(request, HttpRequestOptions.builder().build(), socketId, callback);
    }

    default public CompletableFuture<WebSocket> openWebSocket(HttpRequest request, HttpRequestOptions requestOptions, String socketId, WebSocketCallback callback) {
        throw new UnsupportedOperationException("WebSockets are only supported in Enterprise Edition");
    }

    @Experimental
    default public SseSource sseSource(String url, SseRetryConfig retryConfig) {
        throw new UnsupportedOperationException("Server-sent Events (SSE) are not supported in this HTTP Service version");
    }

    @Experimental
    default public SseSource sseSource(String url) {
        return this.sseSource(url, SseRetryConfig.defaultConfig());
    }
}

