/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.sse.client;

import java.util.Objects;
import java.util.function.Consumer;
import org.mule.api.annotation.Experimental;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.mule.runtime.http.api.sse.client.SseRetryConfig;
import org.mule.runtime.http.api.sse.client.SseSourceConfig;

@Experimental
public class SseSourceConfigBuilder {
    private final String url;
    private SseRetryConfig retryConfig = SseRetryConfig.defaultConfig();
    private Consumer<HttpRequestBuilder> requestCustomizer = b -> {};
    private HttpRequestOptions requestOptions = HttpRequestOptions.builder().build();
    private boolean preserveHeaderCase = HttpServerProperties.PRESERVE_HEADER_CASE;

    public SseSourceConfigBuilder(String url) {
        this.url = Objects.requireNonNull(url);
    }

    public SseSourceConfigBuilder withRetryConfig(SseRetryConfig retryConfig) {
        this.retryConfig = retryConfig;
        return this;
    }

    public SseSourceConfigBuilder withRequestCustomizer(Consumer<HttpRequestBuilder> requestCustomizer) {
        this.requestCustomizer = requestCustomizer;
        return this;
    }

    public SseSourceConfigBuilder withRequestOptions(HttpRequestOptions requestOptions) {
        this.requestOptions = requestOptions;
        return this;
    }

    public SseSourceConfigBuilder withPreserveHeadersCase(boolean preserveHeadersCase) {
        this.preserveHeaderCase = preserveHeadersCase;
        return this;
    }

    public SseSourceConfig build() {
        return new SseSourceConfig(this.url, this.retryConfig, this.requestCustomizer, this.requestOptions, this.preserveHeaderCase);
    }
}

