/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.sse.client;

import java.util.function.Consumer;
import org.mule.api.annotation.Experimental;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.sse.client.SseRetryConfig;
import org.mule.runtime.http.api.sse.client.SseSourceConfigBuilder;
import org.mule.runtime.http.api.sse.client.SseSourceConfigBuilderFromResponse;

@Experimental
public class SseSourceConfig {
    private final String url;
    private final SseRetryConfig retryConfig;
    private final Consumer<HttpRequestBuilder> requestCustomizer;
    private final HttpRequestOptions requestOptions;
    private final boolean preserveHeaderCase;
    private final HttpResponse response;

    public static SseSourceConfigBuilder fromUrl(String url) {
        return new SseSourceConfigBuilder(url);
    }

    public static SseSourceConfigBuilderFromResponse fromResponse(HttpResponse response) {
        return new SseSourceConfigBuilderFromResponse(response);
    }

    SseSourceConfig(String url, SseRetryConfig retryConfig, Consumer<HttpRequestBuilder> requestCustomizer, HttpRequestOptions requestOptions, boolean preserveHeaderCase, HttpResponse response) {
        this.url = url;
        this.retryConfig = retryConfig;
        this.requestCustomizer = requestCustomizer;
        this.requestOptions = requestOptions;
        this.preserveHeaderCase = preserveHeaderCase;
        this.response = response;
    }

    public String getUrl() {
        return this.url;
    }

    public SseRetryConfig getRetryConfig() {
        return this.retryConfig;
    }

    public Consumer<HttpRequestBuilder> getRequestCustomizer() {
        return this.requestCustomizer;
    }

    public HttpRequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    public boolean isPreserveHeaderCase() {
        return this.preserveHeaderCase;
    }

    public HttpResponse getResponse() {
        return this.response;
    }
}

