/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.server;

import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;

public class HttpServerConfiguration {
    private final String host;
    private final int port;
    private final TlsContextFactory tlsContextFactory;
    private final boolean usePersistentConnections;
    private final int connectionIdleTimeout;
    private final String name;
    private final Supplier<Scheduler> schedulerSupplier;
    private final long readTimeout;
    private final Http1ProtocolConfig http1Config;
    private final Http2ProtocolConfig http2Config;
    private static final long DEFAULT_READ_TIMEOUT_MILLIS = 30000L;

    @Deprecated
    HttpServerConfiguration(String host, int port, TlsContextFactory tlsContextFactory, boolean usePersistentConnections, int connectionIdleTimeout, String name, Supplier<Scheduler> schedulerSupplier) {
        this(host, port, tlsContextFactory, usePersistentConnections, connectionIdleTimeout, name, schedulerSupplier, 30000L);
    }

    HttpServerConfiguration(String host, int port, TlsContextFactory tlsContextFactory, boolean usePersistentConnections, int connectionIdleTimeout, String name, Supplier<Scheduler> schedulerSupplier, long readTimeout) {
        this(host, port, tlsContextFactory, usePersistentConnections, connectionIdleTimeout, name, schedulerSupplier, readTimeout, new Http1ProtocolConfig(), new Http2ProtocolConfig());
    }

    HttpServerConfiguration(String host, int port, TlsContextFactory tlsContextFactory, boolean usePersistentConnections, int connectionIdleTimeout, String name, Supplier<Scheduler> schedulerSupplier, long readTimeout, Http1ProtocolConfig http1Config, Http2ProtocolConfig http2Config) {
        this.host = host;
        this.port = port;
        this.tlsContextFactory = tlsContextFactory;
        this.usePersistentConnections = usePersistentConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.name = name;
        this.schedulerSupplier = schedulerSupplier;
        this.readTimeout = readTimeout;
        this.http1Config = http1Config;
        this.http2Config = http2Config;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    public boolean isUsePersistentConnections() {
        return this.usePersistentConnections;
    }

    public int getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public String getName() {
        return this.name;
    }

    public Supplier<Scheduler> getSchedulerSupplier() {
        return this.schedulerSupplier;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public Http1ProtocolConfig getHttp1Config() {
        return this.http1Config;
    }

    public Http2ProtocolConfig getHttp2Config() {
        return this.http2Config;
    }

    public static class Builder {
        private String host;
        private int port;
        private TlsContextFactory tlsContextFactory;
        private boolean usePersistentConnections = true;
        private int connectionIdleTimeout = 30000;
        private Supplier<Scheduler> schedulerSupplier;
        private String name;
        private long readTimeout = 30000L;
        private Http1ProtocolConfig http1Config = new Http1ProtocolConfig();
        private Http2ProtocolConfig http2Config = new Http2ProtocolConfig();

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setTlsContextFactory(TlsContextFactory tlsContextFactory) {
            this.tlsContextFactory = tlsContextFactory;
            return this;
        }

        public Builder setUsePersistentConnections(boolean usePersistentConnections) {
            this.usePersistentConnections = usePersistentConnections;
            return this;
        }

        public Builder setConnectionIdleTimeout(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public Builder setSchedulerSupplier(Supplier<Scheduler> schedulerSupplier) {
            this.schedulerSupplier = schedulerSupplier;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setReadTimeout(long readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setHttp1Config(Http1ProtocolConfig config) {
            this.http1Config = config;
            return this;
        }

        public Builder setHttp2Config(Http2ProtocolConfig config) {
            this.http2Config = config;
            return this;
        }

        public HttpServerConfiguration build() {
            Objects.requireNonNull(this.host, "A host is mandatory");
            Objects.requireNonNull(Integer.valueOf(this.port), "Port is mandatory");
            Objects.requireNonNull(this.name, "Name is mandatory");
            if (!this.http1Config.isEnabled() && !this.http2Config.isEnabled()) {
                throw new IllegalArgumentException("Both HTTP/1 and HTTP/2 protocols are disabled");
            }
            return new HttpServerConfiguration(this.host, this.port, this.tlsContextFactory, this.usePersistentConnections, this.connectionIdleTimeout, this.name, this.schedulerSupplier, this.readTimeout, this.http1Config, this.http2Config);
        }
    }
}

