/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.api.client.proxy;

import static java.util.Objects.requireNonNull;

/**
 * Builder of {@link ProxyConfig.NtlmProxyConfig}s. Instances can only be obtained using
 * {@link ProxyConfig.NtlmProxyConfig#builder()}. At the very least, a host, port, username, password and NTLM domain must be
 * provided.
 *
 * @since 4.0
 */
public final class NtlmProxyConfigBuilder extends BaseProxyConfigBuilder<ProxyConfig.NtlmProxyConfig, NtlmProxyConfigBuilder> {

  private String ntlmDomain;

  protected NtlmProxyConfigBuilder() {}

  public NtlmProxyConfigBuilder ntlmDomain(String ntlmDomain) {
    this.ntlmDomain = ntlmDomain;
    return this;
  }

  @Override
  public ProxyConfig.NtlmProxyConfig build() {
    requireNonNull(username, "A username must be provided for an NTLM proxy.");
    requireNonNull(password, "A password must be provided for an NTLM proxy.");
    return new DefaultNtlmProxyConfig(host, port, username, password, ntlmDomain, nonProxyHosts);
  }
}
