/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.api.server;

import static org.mule.runtime.http.api.AllureConstants.HttpFeature.HTTP_SERVICE;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import static org.junit.jupiter.api.Assertions.assertThrows;

import org.junit.jupiter.api.Test;

import io.qameta.allure.Feature;

@Feature(HTTP_SERVICE)
public class PathAndMethodRequestMatcherBuilderTestCase {

  @Test
  void methodCannotBeNull() {
    var thrown =
        assertThrows(NullPointerException.class, () -> PathAndMethodRequestMatcher.builder().methodRequestMatcher(null));
    assertThat(thrown.getMessage(), is("method matcher cannot be null"));
  }

  @Test
  void pathCannotBeNull() {
    var thrown = assertThrows(IllegalArgumentException.class, () -> PathAndMethodRequestMatcher.builder().path(null));
    assertThat(thrown.getMessage(), is("path cannot be empty nor null"));
  }

  @Test
  void pathCannotBeEmpty() {
    var thrown = assertThrows(IllegalArgumentException.class, () -> PathAndMethodRequestMatcher.builder().path("     "));
    assertThat(thrown.getMessage(), is("path cannot be empty nor null"));
  }

}
