/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.api.client.proxy;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import static org.junit.jupiter.api.Assertions.assertThrows;

import org.junit.jupiter.api.Test;

public abstract class AbstractProxyConfigTestCase<B extends BaseProxyConfigBuilder> {

  protected static final String HOST = "host";
  protected static final int PORT = 8080;
  protected static final String USERNAME = "username";
  protected static final String PASSWORD = "password";
  protected static final String NON_PROXY_HOSTS = "host1,host2";

  protected abstract B getProxyConfigBuilder();

  @Test
  void onlyHost() {
    var thrown = assertThrows(IllegalArgumentException.class, () -> getProxyConfigBuilder().host(HOST).build());
    assertThat(thrown.getMessage(), is("Port must be under 65535. Check that you set the port."));
  }

  @Test
  void onlyPort() {
    var thrown = assertThrows(NullPointerException.class, () -> getProxyConfigBuilder().port(PORT).build());
    assertThat(thrown.getMessage(), is("Host must be not null"));
  }

}
