/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.sse.server;

import java.net.InetSocketAddress;
import org.mule.api.annotation.Experimental;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.sse.server.SseClientConfigBuilder;

@Experimental
public class SseClientConfig {
    private final String clientId;
    private final InetSocketAddress remoteAddress;

    public static SseClientConfigBuilder builderFrom(HttpRequestContext requestContext) {
        return SseClientConfig.builder().withRemoteAddress(SseClientConfig.nullSafeGetAddress(requestContext));
    }

    public static SseClientConfigBuilder builder() {
        return new SseClientConfigBuilder();
    }

    SseClientConfig(String clientId, InetSocketAddress remoteHostAddress) {
        this.clientId = clientId;
        this.remoteAddress = remoteHostAddress;
    }

    public String getClientId() {
        return this.clientId;
    }

    public InetSocketAddress getRemoteHostAddress() {
        return this.remoteAddress;
    }

    private static InetSocketAddress nullSafeGetAddress(HttpRequestContext requestContext) {
        if (requestContext == null) {
            return null;
        }
        ClientConnection clientConnection = requestContext.getClientConnection();
        if (clientConnection == null) {
            return null;
        }
        return clientConnection.getRemoteHostAddress();
    }
}

