/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.soap.api.message.dispatcher;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.soap.message.DispatchingRequest;
import org.mule.runtime.extension.api.soap.message.DispatchingResponse;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.soap.api.exception.DispatchingException;

public final class DefaultHttpMessageDispatcher
implements MessageDispatcher {
    private final HttpClient client;

    public DefaultHttpMessageDispatcher(HttpClient client) {
        this.client = client;
    }

    public DispatchingResponse dispatch(DispatchingRequest context) {
        MultiMap parameters = new MultiMap();
        context.getHeaders().forEach((arg_0, arg_1) -> ((MultiMap)parameters).put(arg_0, arg_1));
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().setUri(context.getAddress()).setMethod(HttpConstants.Method.POST).setEntity((HttpEntity)new InputStreamHttpEntity(context.getContent()))).setHeaders(parameters).build();
        try {
            HttpResponse response = this.client.send(request, 5000, false, null);
            InputStream content = response.getEntity().getContent();
            return new DispatchingResponse(content, this.toHeadersMap(response));
        }
        catch (IOException e) {
            throw new DispatchingException("An error occurred while sending the SOAP request");
        }
        catch (TimeoutException e) {
            throw new DispatchingException("The SOAP request timed out", e);
        }
    }

    private Map<String, String> toHeadersMap(HttpResponse response) {
        return response.getHeaderNames().stream().collect(Collectors.toMap(Function.identity(), name -> response.getHeaderValues(name).stream().collect(Collectors.joining(" "))));
    }
}

