/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.api;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.runtime.tracer.api.sniffer.SpanSnifferManager;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.api.span.validation.Assertion;

public interface EventTracer<T extends Event> {
    public Optional<InternalSpan> startComponentSpan(T var1, InitialSpanInfo var2);

    public Optional<InternalSpan> startComponentSpan(T var1, InitialSpanInfo var2, Assertion var3);

    public void endCurrentSpan(T var1);

    public void endCurrentSpan(T var1, Assertion var2);

    public void injectDistributedTraceContext(EventContext var1, DistributedTraceContextGetter var2);

    default public void recordErrorAtCurrentSpan(T event, boolean isErrorEscapingCurrentSpan) {
        this.recordErrorAtCurrentSpan(event, () -> (Error)event.getError().orElseThrow(() -> new IllegalArgumentException(String.format("Provided event [%s] does not declare an error.", event))), isErrorEscapingCurrentSpan);
    }

    public void recordErrorAtCurrentSpan(T var1, Supplier<Error> var2, boolean var3);

    default public Map<String, String> getDistributedTraceContextMap(T event) {
        return Collections.emptyMap();
    }

    public void setCurrentSpanName(T var1, String var2);

    public void addCurrentSpanAttribute(T var1, String var2, String var3);

    public void addCurrentSpanAttributes(T var1, Map<String, String> var2);

    public SpanSnifferManager getSpanExporterManager();
}

