/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.api.span;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.api.profiling.tracing.SpanDuration;
import org.mule.runtime.api.profiling.tracing.SpanError;
import org.mule.runtime.api.profiling.tracing.SpanIdentifier;
import org.mule.runtime.tracer.api.span.error.InternalSpanError;
import org.mule.runtime.tracer.api.span.exporter.SpanExporter;

public interface InternalSpan
extends Span {
    public static final String THREAD_END_NAME_KEY = "thread.end.name";

    public void end();

    public void addError(InternalSpanError var1);

    default public void addAttribute(String key, String value) {
    }

    default public Optional<String> getAttribute(String key) {
        return Optional.empty();
    }

    public static InternalSpan getAsInternalSpan(Span span) {
        if (span == null) {
            return null;
        }
        if (span instanceof InternalSpan) {
            return (InternalSpan)span;
        }
        return new SpanInternalWrapper(span);
    }

    public void updateName(String var1);

    public SpanExporter getSpanExporter();

    public Map<String, String> getAttributes();

    default public void updateChildSpanExporter(InternalSpan childInternalSpan) {
    }

    public Map<String, String> serializeAsMap();

    default public void updateRootName(String rootName) {
    }

    default public void setRootAttribute(String rootAttributeKey, String rootAttributeValue) {
    }

    public static class SpanInternalWrapper
    implements InternalSpan {
        private final Span span;

        private SpanInternalWrapper(Span span) {
            this.span = span;
        }

        public Span getParent() {
            return this.span.getParent();
        }

        public SpanIdentifier getIdentifier() {
            return this.span.getIdentifier();
        }

        public String getName() {
            return this.span.getName();
        }

        public SpanDuration getDuration() {
            return this.span.getDuration();
        }

        public Set<SpanError> getErrors() {
            return this.span.getErrors();
        }

        public boolean hasErrors() {
            return this.span.hasErrors();
        }

        @Override
        public void end() {
        }

        @Override
        public void addError(InternalSpanError error) {
        }

        @Override
        public void updateName(String name) {
        }

        @Override
        public SpanExporter getSpanExporter() {
            return null;
        }

        @Override
        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> serializeAsMap() {
            return Collections.emptyMap();
        }
    }
}

