/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracing.level.impl.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.observability.FileConfiguration;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.tracer.common.watcher.TracingConfigurationFileWatcher;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.runtime.tracing.level.api.config.TracingLevelConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTracingLevelConfiguration
extends FileConfiguration
implements TracingLevelConfiguration,
Disposable {
    private final String CONFIGURATION_FILE_PATH = System.getProperty("mule.openTelemetry.tracer.exporter.configurationFilePath", this.getConfFolder() + FileSystems.getDefault().getSeparator() + this.getPropertiesFileName());
    private final MuleContext muleContext;
    private static final String CONFIGURATION_FILE_NAME = "tracing-level.conf";
    private static final String LEVEL_PROPERTY_NAME = "mule.openTelemetry.tracer.level";
    private static final String OVERRIDES_PROPERTY_NAME = "mule.openTelemetry.tracer.levelOverrides";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTracingLevelConfiguration.class);
    private final HashMap<String, TracingLevel> tracingLevelOverrides = new HashMap();
    private boolean tracingConfigurationFileWatcherInitialised;
    private TracingLevel tracingLevel = null;
    private JsonNode configuration;
    private List<Runnable> onConfigurationChangeRunnables = Collections.synchronizedList(new ArrayList());
    private URL configurationUrl;
    private TracingConfigurationFileWatcher tracingConfigurationFileWatcher;
    private ConfigurationPropertiesResolver propertyResolver;
    private boolean initialised;

    public FileTracingLevelConfiguration(MuleContext muleContext) {
        super(muleContext);
        this.muleContext = muleContext;
    }

    private Runnable getOnConfigurationChanged() {
        return () -> this.onConfigurationChangeRunnables.forEach(Runnable::run);
    }

    private void setTracingLevels() {
        this.configuration = this.getTracingLevelConfiguration();
        this.propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new SystemPropertiesConfigurationProvider());
        this.setTracingLevel();
        this.setTracingLevelOverrides();
    }

    private void setTracingLevel() {
        String configuredTracingLevel = this.getStringValue(LEVEL_PROPERTY_NAME);
        if (configuredTracingLevel != null) {
            try {
                this.tracingLevel = TracingLevel.valueOf((String)configuredTracingLevel.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(String.format("Wrong tracing level found in configuration file: %s.", configuredTracingLevel));
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private void setTracingLevelOverrides() {
        this.readStringListFromConfig(OVERRIDES_PROPERTY_NAME).forEach(override -> {
            String[] levelOverride = override.split("=");
            if (levelOverride.length != 2) {
                LOGGER.error(String.format("Wrong tracing level override found in configuration file: %s. This override will be ignored.", override));
            } else {
                try {
                    this.tracingLevelOverrides.put(levelOverride[0], TracingLevel.valueOf((String)levelOverride[1].toUpperCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(String.format("Wrong tracing level override found in configuration file: %s. This override will be ignored.", override));
                }
            }
        });
    }

    public TracingLevel getTracingLevel() {
        if (this.tracingLevel == null) {
            this.initialise();
        }
        return this.tracingLevel;
    }

    private void initialise() {
        this.setTracingLevels();
        this.onConfigurationChangeRunnables.add(() -> this.setTracingLevels());
        if (this.configuration != null && !this.tracingConfigurationFileWatcherInitialised) {
            this.tracingConfigurationFileWatcher = new TracingConfigurationFileWatcher(this.configurationUrl.getFile(), this.getOnConfigurationChanged());
            this.tracingConfigurationFileWatcher.start();
            this.tracingConfigurationFileWatcherInitialised = true;
        }
        this.initialised = true;
    }

    public TracingLevel getTracingLevelOverride(String location) {
        TracingLevel tracingLevelOverride;
        if (!this.initialised) {
            this.initialise();
        }
        if ((tracingLevelOverride = this.getTracingLevelOverrideFrom(location)) != null) {
            return tracingLevelOverride;
        }
        return this.tracingLevel;
    }

    public void onConfigurationChange(Consumer<TracingLevelConfiguration> onConfigurationChangeConsumer) {
        this.onConfigurationChangeRunnables.add(() -> onConfigurationChangeConsumer.accept(this));
    }

    public void dispose() {
        if (this.tracingConfigurationFileWatcher != null) {
            this.tracingConfigurationFileWatcher.interrupt();
        }
    }

    private TracingLevel getTracingLevelOverrideFrom(String location) {
        return this.tracingLevelOverrides.get(location);
    }

    private JsonNode getTracingLevelConfiguration() {
        ClassLoaderResourceProvider resourceProvider = new ClassLoaderResourceProvider(this.getExecutionClassLoader(this.muleContext));
        try {
            InputStream is = resourceProvider.getResourceAsStream(this.CONFIGURATION_FILE_PATH);
            this.configurationUrl = ClassUtils.getResourceOrFail((String)this.CONFIGURATION_FILE_PATH, (ClassLoader)this.getExecutionClassLoader(this.muleContext), (boolean)true);
            return FileTracingLevelConfiguration.loadConfiguration((InputStream)is);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected ClassLoader getExecutionClassLoader(MuleContext muleContext) {
        return muleContext.getExecutionClassLoader();
    }

    protected String getPropertiesFileName() {
        return CONFIGURATION_FILE_NAME;
    }

    protected String getConfFolder() {
        return System.getProperty("mule.tracing.level.configuration.path", MuleFoldersUtil.getConfFolder().getAbsolutePath());
    }

    protected boolean isAValueCorrespondingToAPath(String key) {
        return false;
    }

    protected JsonNode getConfiguration() {
        return this.configuration;
    }

    protected ConfigurationPropertiesResolver getPropertyResolver() {
        return this.propertyResolver;
    }
}

