/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracing.level.impl.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.observability.FileConfiguration;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.runtime.tracing.level.api.config.TracingLevelConfiguration;
import org.mule.runtime.tracing.level.impl.config.YAMLConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTracingLevelConfiguration
extends FileConfiguration
implements TracingLevelConfiguration,
Disposable {
    private static final String CONFIGURATION_FILE_NAME = "tracing-level.conf";
    private static final String LEVEL_PROPERTY_NAME = "mule.openTelemetry.tracer.level";
    private static final String OVERRIDES_PROPERTY_NAME = "mule.openTelemetry.tracer.levelOverrides";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTracingLevelConfiguration.class);
    private final HashMap<String, TracingLevel> tracingLevelOverrides = new HashMap();
    private final LazyValue<TracingLevel> tracingLevelInitializer = new LazyValue(() -> {
        this.initialise();
        return null;
    });
    private TracingLevel tracingLevel = null;
    private final MuleContext muleContext;
    private final YAMLConfiguration yamlConfiguration;

    public FileTracingLevelConfiguration(MuleContext muleContext) {
        super(muleContext);
        this.muleContext = muleContext;
        List<Runnable> onConfigurationChangeRunnables = Collections.synchronizedList(new ArrayList<Runnable>(Collections.singletonList(this::setTracingLevels)));
        String configurationFilePath = System.getProperty("mule.openTelemetry.tracer.exporter.configurationFilePath", this.getConfFolder() + FileSystems.getDefault().getSeparator() + this.getPropertiesFileName());
        this.yamlConfiguration = new YAMLConfiguration(muleContext, onConfigurationChangeRunnables, configurationFilePath);
    }

    private void initialise() {
        this.setTracingLevels();
        this.yamlConfiguration.initialiseWatcher();
    }

    private void setTracingLevels() {
        this.yamlConfiguration.loadJSONConfiguration(this.getExecutionClassLoader(this.muleContext));
        this.setTracingLevel();
        this.setTracingLevelOverrides();
    }

    private void setTracingLevel() {
        String configuredTracingLevel = this.yamlConfiguration.getValue(LEVEL_PROPERTY_NAME);
        if (configuredTracingLevel != null) {
            try {
                this.tracingLevel = TracingLevel.valueOf((String)configuredTracingLevel.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(String.format("Wrong tracing level found in configuration file: %s.", configuredTracingLevel));
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private void setTracingLevelOverrides() {
        List<String> overrides = this.yamlConfiguration.getStringListFromConfig(OVERRIDES_PROPERTY_NAME);
        overrides.forEach(override -> {
            String[] levelOverride = override.split("=");
            if (levelOverride.length != 2) {
                LOGGER.error(String.format("Wrong tracing level override found in configuration file: %s. This override will be ignored.", override));
            } else {
                try {
                    this.tracingLevelOverrides.put(levelOverride[0], TracingLevel.valueOf((String)levelOverride[1].toUpperCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(String.format("Wrong tracing level override found in configuration file: %s. This override will be ignored.", override));
                }
            }
        });
    }

    public TracingLevel getTracingLevel() {
        this.tracingLevelInitializer.get();
        return this.tracingLevel;
    }

    public TracingLevel getTracingLevelOverride(String location) {
        this.tracingLevelInitializer.get();
        TracingLevel tracingLevelOverride = this.getTracingLevelOverrideFrom(location);
        return tracingLevelOverride != null ? tracingLevelOverride : this.tracingLevel;
    }

    public void onConfigurationChange(Consumer<TracingLevelConfiguration> onConfigurationChangeConsumer) {
        this.yamlConfiguration.onConfigurationChange(() -> onConfigurationChangeConsumer.accept(this));
    }

    public void dispose() {
        this.yamlConfiguration.dispose();
    }

    private TracingLevel getTracingLevelOverrideFrom(String location) {
        return this.tracingLevelOverrides.get(location);
    }

    protected ClassLoader getExecutionClassLoader(MuleContext muleContext) {
        return muleContext.getExecutionClassLoader();
    }

    protected String getPropertiesFileName() {
        return CONFIGURATION_FILE_NAME;
    }

    protected String getConfFolder() {
        return System.getProperty("mule.tracing.level.configuration.path", MuleFoldersUtil.getConfFolder().getAbsolutePath());
    }

    protected boolean isAValueCorrespondingToAPath(String key) {
        return this.yamlConfiguration.isAValueCorrespondingToAPath(key);
    }

    protected JsonNode getConfiguration() {
        return this.yamlConfiguration.getConfiguration();
    }

    protected ConfigurationPropertiesResolver getPropertyResolver() {
        return this.yamlConfiguration.getPropertyResolver();
    }
}

