/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.tracer.exporter.impl.optel.config;

import static org.mule.test.allure.AllureConstants.Profiling.PROFILING;
import static org.mule.test.allure.AllureConstants.Profiling.ProfilingServiceStory.TRACING_CONFIGURATION;

import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.verify;

import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.junit.jupiter.api.Test;

@Feature(PROFILING)
@Story(TRACING_CONFIGURATION)
class OpenTelemetryAutoConfigurableSpanExporterConfigurationTestCase {

  @Test
  @Issue("W-13521171")
  void disposeConfiguration() {
    ObservabilitySignalConfiguration disposableSignalConfigurationDelegate = spy(new NoConfigurationDelegate());

    OpenTelemetryAutoConfigurableSpanExporterConfiguration spanExporterConfiguration =
        new OpenTelemetryAutoConfigurableSpanExporterConfiguration(disposableSignalConfigurationDelegate);

    spanExporterConfiguration.dispose();

    // Verify that the delegate (CompositeSpanExporterConfiguration), and the composite configurations were disposed
    verify((Disposable) disposableSignalConfigurationDelegate).dispose();
  }

  private static class NoConfigurationDelegate implements ObservabilitySignalConfiguration, Disposable {

    @Override
    public String getStringValue(String key) {
      return null;
    }

    @Override
    public String getStringValue(String key, String defaultValue) {
      return defaultValue;
    }

    @Override
    public void doOnConfigurationChanged(Runnable doOnConfigurationChanged) {
      // Nothing to do.
    }

    @Override
    public void dispose() {
      // Nothing to do.
    }
  }
}
