/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.profiling.tracing.SpanError;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.error.InternalSpanError;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.impl.exporter.optel.resources.OpenTelemetryResources;
import org.mule.runtime.tracer.impl.exporter.optel.span.MuleOpenTelemetrySpan;

public class DecoratedMuleOpenTelemetrySpan
implements MuleOpenTelemetrySpan {
    private static final TextMapSetter<Map<String, String>> SETTER = Map::put;
    public static final String EXCEPTION_EVENT_NAME = "exception";
    public static final AttributeKey<String> EXCEPTION_TYPE_KEY = AttributeKey.stringKey((String)"exception.type");
    public static final AttributeKey<String> EXCEPTION_MESSAGE_KEY = AttributeKey.stringKey((String)"exception.message");
    public static final AttributeKey<String> EXCEPTION_STACK_TRACE_KEY = AttributeKey.stringKey((String)"exception.stacktrace");
    public static final AttributeKey<Boolean> EXCEPTION_ESCAPED_KEY = AttributeKey.booleanKey((String)"exception.escaped");
    public static final String EXCEPTIONS_HAS_BEEN_RECORDED = "Exceptions has been recorded.";
    public static final String ARTIFACT_ID = "artifact.id";
    public static final String ARTIFACT_TYPE = "artifact.type";
    public static final String SPAN_KIND = "span.kind.override";
    public static final String STATUS = "status.override";
    public static final String SDK_SPAN_CLASS = "io.opentelemetry.sdk.trace.SdkSpan";
    public static final String SPAN_KIND_FIELD_NAME = "kind";
    public static final Field SPAN_KIND_FIELD = DecoratedMuleOpenTelemetrySpan.getSpanKindField();
    private final Span delegate;
    private Set<String> noExportableUntil = new HashSet<String>();
    private boolean policy;
    private boolean root;

    private static Field getSpanKindField() {
        try {
            Field spanKindField = Class.forName(SDK_SPAN_CLASS).getDeclaredField(SPAN_KIND_FIELD_NAME);
            spanKindField.setAccessible(true);
            return spanKindField;
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            return null;
        }
    }

    public DecoratedMuleOpenTelemetrySpan(Span delegate) {
        this.delegate = delegate;
    }

    @Override
    public Context getSpanOpenTelemetryContext() {
        return Context.current().with((ImplicitContextKeyed)this.delegate);
    }

    @Override
    public void end(InternalSpan internalSpan, InitialSpanInfo initialSpanInfo, String artifactId, String artifactType) {
        if (internalSpan.hasErrors()) {
            this.delegate.setStatus(StatusCode.ERROR, EXCEPTIONS_HAS_BEEN_RECORDED);
            this.recordSpanExceptions(internalSpan);
        }
        initialSpanInfo.getInitialAttributes().forEach((arg_0, arg_1) -> ((Span)this.delegate).setAttribute(arg_0, arg_1));
        this.updateSpanKind(internalSpan);
        this.updateSpanStatus(internalSpan);
        internalSpan.getAttributes().forEach((arg_0, arg_1) -> ((Span)this.delegate).setAttribute(arg_0, arg_1));
        this.delegate.setAttribute(ARTIFACT_ID, artifactId);
        this.delegate.setAttribute(ARTIFACT_TYPE, artifactType);
        this.delegate.end(internalSpan.getDuration().getEnd().longValue(), TimeUnit.NANOSECONDS);
    }

    private void updateSpanStatus(InternalSpan internalSpan) {
        String spanStatus = (String)internalSpan.getAttributes().remove(STATUS);
        if (spanStatus != null) {
            this.delegate.setStatus(StatusCode.valueOf((String)spanStatus));
        }
    }

    private void updateSpanKind(InternalSpan internalSpan) {
        String spanKind = (String)internalSpan.getAttributes().remove(SPAN_KIND);
        if (spanKind != null && SPAN_KIND_FIELD != null && this.delegate.getClass().getName().equals(SDK_SPAN_CLASS)) {
            try {
                SPAN_KIND_FIELD.set(this.delegate, SpanKind.valueOf((String)spanKind));
            }
            catch (IllegalAccessException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Span Kind of span: %s could not be changed to: %s", internalSpan.getName(), spanKind)), (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, String> getDistributedTraceContextMap() {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        OpenTelemetryResources.getPropagator().getTextMapPropagator().inject(this.getSpanOpenTelemetryContext(), contextMap, SETTER);
        return contextMap;
    }

    @Override
    public void setNoExportUntil(Set<String> noExportableUntil) {
        this.noExportableUntil = noExportableUntil;
    }

    @Override
    public Set<String> getNoExportUntil() {
        return this.noExportableUntil;
    }

    @Override
    public void setPolicy(boolean policy) {
        this.policy = policy;
    }

    @Override
    public void setRoot(boolean root) {
        this.root = root;
    }

    @Override
    public boolean onlyPropagateNamesAndAttributes() {
        return this.policy;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    public <T> Span setAttribute(AttributeKey<T> attributeKey, T t) {
        return this.delegate.setAttribute(attributeKey, t);
    }

    public Span setAttribute(String key, String value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span addEvent(String s, Attributes attributes) {
        return this.delegate.addEvent(s, attributes);
    }

    public Span addEvent(String s, Attributes attributes, long l, TimeUnit timeUnit) {
        return this.delegate.addEvent(s, attributes, l, timeUnit);
    }

    public Span setStatus(StatusCode statusCode, String s) {
        return this.delegate.setStatus(statusCode, s);
    }

    public Span recordException(Throwable throwable, Attributes attributes) {
        return this.delegate.recordException(throwable, attributes);
    }

    public Span updateName(String newName) {
        return this.delegate.updateName(newName);
    }

    public void end() {
        this.delegate.end();
    }

    public void end(long l, TimeUnit timeUnit) {
        this.delegate.end(l, timeUnit);
    }

    public SpanContext getSpanContext() {
        return this.delegate.getSpanContext();
    }

    public boolean isRecording() {
        return this.delegate.isRecording();
    }

    private void recordSpanExceptions(InternalSpan internalSpan) {
        internalSpan.getErrors().forEach(this::recordSpanException);
    }

    private void recordSpanException(SpanError spanError) {
        Attributes errorAttributes = Attributes.of(EXCEPTION_TYPE_KEY, (Object)spanError.getError().getErrorType().toString(), EXCEPTION_MESSAGE_KEY, (Object)spanError.getError().getDescription(), EXCEPTION_STACK_TRACE_KEY, (Object)InternalSpanError.getInternalSpanError((SpanError)spanError).getErrorStacktrace().toString(), EXCEPTION_ESCAPED_KEY, (Object)spanError.isEscapingSpan());
        this.delegate.addEvent(EXCEPTION_EVENT_NAME, errorAttributes);
    }
}

