/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.exporter.SpanExporter;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.impl.exporter.optel.span.MuleOpenTelemetrySpan;
import org.mule.runtime.tracer.impl.exporter.optel.span.NoExportInitialSpanInfo;
import org.mule.runtime.tracer.impl.exporter.optel.span.provider.MuleOpenTelemetrySpanProvider;

public class OpenTelemetrySpanExporter
implements SpanExporter {
    public static final String NO_EXPORTABLE_SERVICE = "no-exportable-service";
    private final InternalSpan internalSpan;
    private final InitialSpanInfo initialSpanInfo;
    private final String artifactId;
    private final String artifactType;
    private MuleOpenTelemetrySpan openTelemetrySpan;
    private OpenTelemetrySpanExporter rootSpan = this;
    private String rootName;
    private final Map<String, String> rootAttributes = new HashMap<String, String>();

    public static OpenTelemetrySpanExportBuilder builder() {
        return new OpenTelemetrySpanExportBuilder();
    }

    private OpenTelemetrySpanExporter(InternalSpan internalSpan, InitialSpanInfo initialSpanInfo, String artifactId, String artifactType) {
        this.internalSpan = internalSpan;
        this.initialSpanInfo = initialSpanInfo;
        this.artifactId = artifactId;
        this.artifactType = artifactType;
    }

    public void export() {
        this.openTelemetrySpan.end(this.internalSpan, this.initialSpanInfo, this.artifactId, this.artifactType);
    }

    public void updateNameForExport(String newName) {
        if (this.rootSpan != this) {
            this.rootSpan.updateNameForExport(newName);
        } else {
            this.openTelemetrySpan.updateName(newName);
        }
    }

    public Map<String, String> exportedSpanAsMap() {
        return this.openTelemetrySpan.getDistributedTraceContextMap();
    }

    public MuleOpenTelemetrySpan getOpenTelemetrySpan() {
        return this.openTelemetrySpan;
    }

    public void setRootName(String rootName) {
        if (this.openTelemetrySpan.isRoot()) {
            this.openTelemetrySpan.updateName(rootName);
        } else {
            this.rootName = rootName;
        }
    }

    public void setRootAttribute(String rootAttributeKey, String rootAttributeValue) {
        if (this.openTelemetrySpan.isRoot()) {
            this.openTelemetrySpan.setAttribute(rootAttributeKey, rootAttributeValue);
        } else {
            this.rootAttributes.put(rootAttributeKey, rootAttributeValue);
        }
    }

    public void updateChildSpanExporter(SpanExporter childSpanExporter) {
        if (childSpanExporter instanceof OpenTelemetrySpanExporter) {
            OpenTelemetrySpanExporter childOpenTelemetrySpanExporter = (OpenTelemetrySpanExporter)childSpanExporter;
            if (childOpenTelemetrySpanExporter.getOpenTelemetrySpan().onlyPropagateNamesAndAttributes()) {
                childOpenTelemetrySpanExporter.setRootSpan(this.rootSpan);
            }
            if (this.rootName != null) {
                childOpenTelemetrySpanExporter.setRootName(this.rootName);
                this.rootAttributes.forEach(childOpenTelemetrySpanExporter::setRootAttribute);
            }
            if (!this.openTelemetrySpan.getNoExportUntil().isEmpty() && !this.openTelemetrySpan.getNoExportUntil().contains(this.getWithoutNamespace(childSpanExporter.getInternalSpan().getName()))) {
                childOpenTelemetrySpanExporter.openTelemetrySpan = MuleOpenTelemetrySpanProvider.getNewOpenTelemetrySpan(this.internalSpan, new NoExportInitialSpanInfo(childOpenTelemetrySpanExporter.getOpenTelemetrySpan().getNoExportUntil()), NO_EXPORTABLE_SERVICE);
            }
        }
    }

    private void setRootSpan(OpenTelemetrySpanExporter openTelemetrySpan) {
        this.rootSpan = openTelemetrySpan;
    }

    private String getWithoutNamespace(String name) {
        int index = name.lastIndexOf(":");
        if (index != -1) {
            return name.substring(index + 1);
        }
        return name;
    }

    public InternalSpan getInternalSpan() {
        return this.internalSpan;
    }

    public static class OpenTelemetrySpanExportBuilder {
        private InitialSpanInfo initialSpanInfo;
        private InternalSpan internalSpan;
        private String artifactId;
        private String artifactType;

        public OpenTelemetrySpanExportBuilder withStartSpanInfo(InitialSpanInfo initialSpanInfo) {
            this.initialSpanInfo = initialSpanInfo;
            return this;
        }

        public OpenTelemetrySpanExportBuilder withInternalSpan(InternalSpan internalSpan) {
            this.internalSpan = internalSpan;
            return this;
        }

        public OpenTelemetrySpanExportBuilder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public OpenTelemetrySpanExportBuilder withArtifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public OpenTelemetrySpanExporter build() {
            if (this.initialSpanInfo == null) {
                throw new IllegalArgumentException("Start span info is null");
            }
            if (this.artifactId == null) {
                throw new IllegalArgumentException("Artifact id is null");
            }
            if (this.artifactType == null) {
                throw new IllegalArgumentException("Artifact type is null");
            }
            OpenTelemetrySpanExporter openTelemetrySpanExporter = new OpenTelemetrySpanExporter(this.internalSpan, this.initialSpanInfo, this.artifactId, this.artifactType);
            openTelemetrySpanExporter.openTelemetrySpan = MuleOpenTelemetrySpanProvider.getNewOpenTelemetrySpan(this.internalSpan, this.initialSpanInfo, this.artifactId);
            return openTelemetrySpanExporter;
        }
    }
}

