/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.api.profiling.tracing.SpanError;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.error.InternalSpanError;
import org.mule.runtime.tracer.api.span.exporter.SpanExporter;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.impl.exporter.OpenTelemetrySpanExporterUtils;
import org.mule.runtime.tracer.impl.exporter.OpenTelemetryTraceIdUtils;
import org.mule.runtime.tracer.impl.exporter.optel.resources.OpenTelemetryResources;

public class OpenTelemetrySpanExporter
implements SpanExporter,
SpanData,
ReadableSpan,
Attributes {
    private static final String MULE_INSTRUMENTATION_LIBRARY = "mule";
    private static final String MULE_INSTRUMENTATION_LIBRARY_VERSION = "1.0.0";
    public static final int EXPORTER_ATTRIBUTES_BASE_SIZE = 3;
    private final boolean isRootSpan;
    private final boolean isPolicySpan;
    private final InternalSpan internalSpan;
    private final String artifactId;
    private final String artifactType;
    private final Map<String, String> rootAttributes = new HashMap<String, String>();
    private final SpanProcessor spanProcessor;
    private boolean exportable;
    private SpanContext spanContext;
    private SpanContext parentSpanContext = SpanContext.getInvalid();
    private SpanKind spanKind = SpanKind.INTERNAL;
    private StatusData statusData = StatusData.ok();
    private List<EventData> errorEvents = Collections.emptyList();
    private String overriddenSpanName;
    private Set<String> noExportUntil;
    private OpenTelemetrySpanExporter rootSpan = this;
    private String rootName;
    private String endThreadNameValue;

    private OpenTelemetrySpanExporter(InternalSpan internalSpan, InitialSpanInfo initialSpanInfo, String artifactId, String artifactType, SpanProcessor spanProcessor) {
        this.internalSpan = internalSpan;
        this.noExportUntil = initialSpanInfo.getInitialExportInfo().noExportUntil();
        this.isRootSpan = initialSpanInfo.isRootSpan();
        this.isPolicySpan = initialSpanInfo.isPolicySpan();
        this.exportable = initialSpanInfo.getInitialExportInfo().isExportable();
        this.artifactId = artifactId;
        this.artifactType = artifactType;
        this.spanProcessor = spanProcessor;
        this.spanContext = SpanContext.create((String)OpenTelemetryTraceIdUtils.generateTraceId(InternalSpan.getAsInternalSpan((Span)internalSpan.getParent())), (String)OpenTelemetryTraceIdUtils.generateSpanId(), (TraceFlags)TraceFlags.getSampled(), (TraceState)TraceState.getDefault());
    }

    @Nullable
    public <T> T get(@Nullable AttributeKey<T> attributeKey) {
        throw new UnsupportedOperationException();
    }

    public void forEach(BiConsumer<? super AttributeKey<?>, ? super Object> biConsumer) {
        biConsumer.accept(OpenTelemetrySpanExporterUtils.ARTIFACT_ID, this.artifactId);
        biConsumer.accept(OpenTelemetrySpanExporterUtils.ARTIFACT_TYPE, this.artifactType);
        biConsumer.accept(OpenTelemetrySpanExporterUtils.THREAD_END_NAME_KEY, this.endThreadNameValue);
        this.internalSpan.forEachAttribute((key, value) -> biConsumer.accept(AttributeKey.stringKey((String)key), value));
    }

    public int size() {
        return 3 + this.internalSpan.getAttributesCount();
    }

    public boolean isEmpty() {
        return false;
    }

    public Map<AttributeKey<?>, Object> asMap() {
        HashMap attributes = new HashMap();
        this.forEach(attributes::put);
        return attributes;
    }

    public static OpenTelemetrySpanExportBuilder builder() {
        return new OpenTelemetrySpanExportBuilder();
    }

    public AttributesBuilder toBuilder() {
        throw new UnsupportedOperationException();
    }

    public void export() {
        if (this.exportable) {
            this.endThreadNameValue = Thread.currentThread().getName();
            this.spanProcessor.onEnd((ReadableSpan)this);
        }
    }

    public void updateNameForExport(String newName) {
        if (this.rootSpan != this) {
            this.rootSpan.updateNameForExport(newName);
        } else {
            this.overriddenSpanName = newName;
        }
    }

    public Map<String, String> exportedSpanAsMap() {
        return OpenTelemetryTraceIdUtils.getContext(this);
    }

    public void setRootName(String rootName) {
        if (this.isRootSpan) {
            this.overriddenSpanName = rootName;
        } else {
            this.rootName = rootName;
        }
    }

    public void setRootAttribute(String rootAttributeKey, String rootAttributeValue) {
        if (this.isRootSpan) {
            this.internalSpan.addAttribute(rootAttributeKey, rootAttributeValue);
        } else {
            this.rootAttributes.put(rootAttributeKey, rootAttributeValue);
        }
    }

    public void updateParentSpanFrom(Map<String, String> serializeAsMap) {
        this.parentSpanContext = OpenTelemetryTraceIdUtils.extractContextFromTraceParent(serializeAsMap.get("traceparent"));
        if (this.parentSpanContext.isValid()) {
            this.spanContext = SpanContext.create((String)this.parentSpanContext.getTraceId(), (String)this.spanContext.getSpanId(), (TraceFlags)TraceFlags.getSampled(), (TraceState)TraceState.getDefault());
        }
    }

    public void updateChildSpanExporter(SpanExporter childSpanExporter) {
        if (childSpanExporter instanceof OpenTelemetrySpanExporter) {
            OpenTelemetrySpanExporter childOpenTelemetrySpanExporter = (OpenTelemetrySpanExporter)childSpanExporter;
            if (!childOpenTelemetrySpanExporter.exportable) {
                childOpenTelemetrySpanExporter.parentSpanContext = this.parentSpanContext;
                childOpenTelemetrySpanExporter.spanContext = this.spanContext;
                childOpenTelemetrySpanExporter.rootSpan = this.rootSpan;
                childOpenTelemetrySpanExporter.noExportUntil = this.noExportUntil;
                childOpenTelemetrySpanExporter.setRootName(this.rootName);
                return;
            }
            if (childOpenTelemetrySpanExporter.isPolicySpan) {
                childOpenTelemetrySpanExporter.setRootName(this.rootName);
                childOpenTelemetrySpanExporter.rootSpan = this.rootSpan;
            }
            if (this.rootName != null) {
                childOpenTelemetrySpanExporter.setRootName(this.rootName);
                this.rootAttributes.forEach(childOpenTelemetrySpanExporter::setRootAttribute);
            }
            if (!this.noExportUntil.isEmpty() && !this.noExportUntil.contains(OpenTelemetrySpanExporterUtils.getNameWithoutNamespace(childSpanExporter.getInternalSpan().getName()))) {
                childOpenTelemetrySpanExporter.parentSpanContext = this.parentSpanContext;
                childOpenTelemetrySpanExporter.noExportUntil = this.noExportUntil;
                childOpenTelemetrySpanExporter.spanContext = this.spanContext;
                childOpenTelemetrySpanExporter.rootSpan = this.rootSpan;
                childOpenTelemetrySpanExporter.exportable = false;
            }
            if (childOpenTelemetrySpanExporter.parentSpanContext == SpanContext.getInvalid()) {
                childOpenTelemetrySpanExporter.parentSpanContext = this.spanContext;
            }
        }
    }

    public InternalSpan getInternalSpan() {
        return this.internalSpan;
    }

    public String getName() {
        if (this.overriddenSpanName == null) {
            return this.internalSpan.getName();
        }
        return this.overriddenSpanName;
    }

    public SpanKind getKind() {
        return this.spanKind;
    }

    public void onAdditionalAttribute(String key, String value) {
        if (key.equals("span.kind.override")) {
            this.spanKind = SpanKind.valueOf((String)value);
        }
        if (key.equals("status.override")) {
            StatusCode statusCode = StatusCode.valueOf((String)value);
            this.statusData = StatusData.create((StatusCode)statusCode, null);
        }
    }

    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    public SpanContext getParentSpanContext() {
        return this.parentSpanContext;
    }

    public String getParentSpanId() {
        return super.getParentSpanId();
    }

    public StatusData getStatus() {
        return this.statusData;
    }

    public long getStartEpochNanos() {
        return this.internalSpan.getDuration().getStart();
    }

    public Attributes getAttributes() {
        return this;
    }

    public List<EventData> getEvents() {
        return this.errorEvents;
    }

    public void onError(InternalSpanError spanError) {
        this.statusData = StatusData.create((StatusCode)StatusCode.ERROR, (String)"Exceptions have been recorded.");
        Attributes errorAttributes = Attributes.of(OpenTelemetrySpanExporterUtils.EXCEPTION_TYPE_KEY, (Object)spanError.getError().getErrorType().toString(), OpenTelemetrySpanExporterUtils.EXCEPTION_MESSAGE_KEY, (Object)spanError.getError().getDescription(), OpenTelemetrySpanExporterUtils.EXCEPTION_STACK_TRACE_KEY, (Object)InternalSpanError.getInternalSpanError((SpanError)spanError).getErrorStacktrace().toString(), OpenTelemetrySpanExporterUtils.EXCEPTION_ESCAPED_KEY, (Object)spanError.isEscapingSpan());
        this.errorEvents = Collections.singletonList(EventData.create((long)System.currentTimeMillis(), (String)"exception", (Attributes)errorAttributes));
    }

    public List<LinkData> getLinks() {
        return Collections.emptyList();
    }

    public long getEndEpochNanos() {
        return this.internalSpan.getDuration().getEnd();
    }

    public boolean hasEnded() {
        return true;
    }

    public int getTotalRecordedEvents() {
        if (this.errorEvents.isEmpty()) {
            return 0;
        }
        return 1;
    }

    public int getTotalRecordedLinks() {
        return 0;
    }

    public int getTotalAttributeCount() {
        return this.size();
    }

    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return InstrumentationLibraryInfo.create((String)MULE_INSTRUMENTATION_LIBRARY, (String)MULE_INSTRUMENTATION_LIBRARY_VERSION);
    }

    public Resource getResource() {
        return OpenTelemetryResources.getResource(this.artifactId);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public String getOverriddenSpanName() {
        return this.overriddenSpanName;
    }

    public SpanData toSpanData() {
        return this;
    }

    public long getLatencyNanos() {
        return 0L;
    }

    @Nullable
    public <T> T getAttribute(@Nullable AttributeKey<T> attributeKey) {
        throw new UnsupportedOperationException();
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return super.getInstrumentationScopeInfo();
    }

    public static class OpenTelemetrySpanExportBuilder {
        private InitialSpanInfo initialSpanInfo;
        private InternalSpan internalSpan;
        private String artifactId;
        private String artifactType;
        private SpanProcessor spanProcessor;

        public OpenTelemetrySpanExportBuilder withStartSpanInfo(InitialSpanInfo initialSpanInfo) {
            this.initialSpanInfo = initialSpanInfo;
            return this;
        }

        public OpenTelemetrySpanExportBuilder withInternalSpan(InternalSpan internalSpan) {
            this.internalSpan = internalSpan;
            return this;
        }

        public OpenTelemetrySpanExportBuilder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public OpenTelemetrySpanExportBuilder withArtifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public OpenTelemetrySpanExportBuilder withSpanProcessor(SpanProcessor spanProcessor) {
            this.spanProcessor = spanProcessor;
            return this;
        }

        public OpenTelemetrySpanExporter build() {
            if (this.initialSpanInfo == null) {
                throw new IllegalArgumentException("Start span info is null");
            }
            if (this.artifactId == null) {
                throw new IllegalArgumentException("Artifact id is null");
            }
            if (this.artifactType == null) {
                throw new IllegalArgumentException("Artifact type is null");
            }
            if (this.spanProcessor == null) {
                throw new IllegalArgumentException("Artifact type is null");
            }
            return new OpenTelemetrySpanExporter(this.internalSpan, this.initialSpanInfo, this.artifactId, this.artifactType, this.spanProcessor);
        }
    }
}

