/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter.optel.config;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.tracer.exporter.api.config.FileSpanExporterConfiguration;
import org.mule.runtime.tracer.exporter.api.config.SpanExporterConfiguration;

public class OpenTelemetryAutoConfigurableSpanExporterConfiguration
implements SpanExporterConfiguration {
    @Inject
    private MuleContext muleContext;
    private static final String DEFAULT_BACKOFF_MULTIPLIER = "1.5";
    private static final String DEFAULT_INITIAL_BACKOFF = "1";
    private static final String DEFAULT_MAXIMUM_BACKOFF = "5";
    private static final String DEFAULT_BACKOFF_MAX_ATTEMPTS = "5";
    public static final String GRPC_EXPORTER_TYPE = "GRPC";
    public static final String DEFAULT_EXPORTER_TYPE = "GRPC";
    public static final String DEFAULT_GRPC_EXPORTER_ENDPOINT = "http://localhost:4317";
    public static final String DEFAULT_HTTP_EXPORTER_ENDPOINT = "http://localhost:4318/v1/traces";
    public static final String DEFAULT_EXPORTER_TIMEOUT = "10000";
    private SpanExporterConfiguration delegate;
    private final Map<String, String> defaultConfigurationValues = new HashMap<String, String>();

    public OpenTelemetryAutoConfigurableSpanExporterConfiguration() {
    }

    public OpenTelemetryAutoConfigurableSpanExporterConfiguration(SpanExporterConfiguration delegate) {
        this.delegate = delegate;
        this.initialiseDefaultConfigurationValues();
    }

    public String getStringValue(String key) {
        try {
            if (this.delegate == null) {
                this.delegate = new FileSpanExporterConfiguration(this.muleContext);
                this.initialiseDefaultConfigurationValues();
            }
            return this.delegate.getStringValue(key, this.defaultConfigurationValues.get(key));
        }
        catch (PropertyNotFoundException e) {
            return this.defaultConfigurationValues.get(key);
        }
    }

    private void initialiseDefaultConfigurationValues() {
        this.defaultConfigurationValues.put("mule.open.telemetry.exporter.enabled", "false");
        this.defaultConfigurationValues.put("mule.open.telemetry.exporter.type", "GRPC");
        if (this.getStringValue("mule.open.telemetry.exporter.type").equals("GRPC")) {
            this.defaultConfigurationValues.put("mule.open.telemetry.exporter.endpoint", DEFAULT_GRPC_EXPORTER_ENDPOINT);
        } else {
            this.defaultConfigurationValues.put("mule.open.telemetry.exporter.endpoint", DEFAULT_HTTP_EXPORTER_ENDPOINT);
        }
        this.defaultConfigurationValues.put("mule.open.telemetry.exporter.timeout", DEFAULT_EXPORTER_TIMEOUT);
        this.defaultConfigurationValues.put("mule.open.telemetry.exporterbackoff.multiplier", DEFAULT_BACKOFF_MULTIPLIER);
        this.defaultConfigurationValues.put("mule.open.telemetry.exporter.backoff.initial", DEFAULT_INITIAL_BACKOFF);
        this.defaultConfigurationValues.put("mule.open.telemetry.exporterbackoff.max", "5");
        this.defaultConfigurationValues.put("mule.open.telemetry.exporterbackoff.max.attempts", "5");
    }
}

