/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.api.profiling.tracing.SpanDuration;
import org.mule.runtime.api.profiling.tracing.SpanError;
import org.mule.runtime.api.profiling.tracing.SpanIdentifier;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.error.InternalSpanError;
import org.mule.runtime.tracer.api.span.exporter.SpanExporter;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.exporter.api.SpanExporterFactory;
import org.mule.runtime.tracer.impl.clock.Clock;

public class ExecutionSpan
implements InternalSpan {
    public static final String THREAD_END_NAME = "thread.end.name";
    private final InitialSpanInfo initialSpanInfo;
    private SpanExporter spanExporter = SpanExporter.NOOP_EXPORTER;
    private final InternalSpan parent;
    private final Long startTime;
    private Long endTime;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final Set<SpanError> errors = new HashSet<SpanError>();

    public static ExecutionSpanBuilder getExecutionSpanBuilder() {
        return new ExecutionSpanBuilder();
    }

    private ExecutionSpan(InitialSpanInfo initialSpanInfo, Long startTime, InternalSpan parent) {
        this.initialSpanInfo = initialSpanInfo;
        this.startTime = startTime;
        this.parent = parent;
    }

    public Span getParent() {
        return this.parent;
    }

    public SpanIdentifier getIdentifier() {
        return null;
    }

    public String getName() {
        return this.initialSpanInfo.getName();
    }

    public SpanDuration getDuration() {
        return new DefaultSpanDuration(this.startTime, this.endTime);
    }

    public Set<SpanError> getErrors() {
        return this.errors;
    }

    public void setRootAttribute(String s, String s1) {
        this.spanExporter.setRootAttribute(s, s1);
    }

    public void updateRootName(String name) {
        this.spanExporter.setRootName(name);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void end() {
        this.attributes.put(THREAD_END_NAME, Thread.currentThread().getName());
        this.endTime = Clock.getDefault().now();
        this.spanExporter.export();
    }

    public void addError(InternalSpanError error) {
        this.errors.add((SpanError)error);
    }

    public void updateName(String name) {
        this.spanExporter.updateNameForExport(name);
    }

    public SpanExporter getSpanExporter() {
        return this.spanExporter;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> serializeAsMap() {
        return this.spanExporter.exportedSpanAsMap();
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public Optional<String> getAttribute(String key) {
        return Optional.ofNullable(this.attributes.get(key));
    }

    public void updateChildSpanExporter(InternalSpan internalSpan) {
        this.spanExporter.updateChildSpanExporter(internalSpan.getSpanExporter());
    }

    public static class ExecutionSpanBuilder {
        public static final String THERE_IS_NO_SPAN_FACTORY_MESSAGE = "there is no span factory";
        private InternalSpan parent;
        private Long startTime;
        private SpanExporterFactory spanExporterFactory;
        private InitialSpanInfo initialSpanInfo;

        private ExecutionSpanBuilder() {
        }

        public ExecutionSpanBuilder withStartSpanInfo(InitialSpanInfo spanCustomizationInfo) {
            this.initialSpanInfo = spanCustomizationInfo;
            return this;
        }

        public ExecutionSpanBuilder withParentSpan(InternalSpan parent) {
            this.parent = parent;
            return this;
        }

        public ExecutionSpanBuilder withSpanExporterFactory(SpanExporterFactory spanExporterFactory) {
            this.spanExporterFactory = spanExporterFactory;
            return this;
        }

        public ExecutionSpan build() {
            if (this.startTime == null) {
                this.startTime = Clock.getDefault().now();
            }
            if (this.spanExporterFactory == null) {
                throw new IllegalArgumentException(THERE_IS_NO_SPAN_FACTORY_MESSAGE);
            }
            ExecutionSpan executionSpan = new ExecutionSpan(this.initialSpanInfo, this.startTime, this.parent);
            executionSpan.spanExporter = this.spanExporterFactory.getSpanExporter((InternalSpan)executionSpan, this.initialSpanInfo);
            return executionSpan;
        }
    }

    private static class DefaultSpanDuration
    implements SpanDuration {
        private final Long startTime;
        private final Long endTime;

        public DefaultSpanDuration(Long startTime, Long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Long getStart() {
            return this.startTime;
        }

        public Long getEnd() {
            return this.endTime;
        }
    }
}

