/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.plugin.maven.AbstractPackagePluginMojo;
import org.mule.plugin.maven.ModuleArchiver;
import org.mule.plugin.maven.PluginProperties;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PluginPackageMojo
extends AbstractPackagePluginMojo {
    public static final String MULE_PLUGIN_JSON_LOCATION = RESERVED_FOLDER_MULE_ARTIFACT + "mule-plugin.json";
    public static final String META_INF = "META-INF";
    public static final String MULE_ARTIFACT = "mule-artifact";
    public static final String CLASSES = "classes";
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File baseDir;
    @Parameter(defaultValue="plugin.properties")
    private File customPluginProperties;

    protected void addToArchiver(ModuleArchiver archiver) throws MojoFailureException {
        this.addPOMFile(archiver);
        this.addPluginDescriptor(archiver);
        this.addClasses(archiver);
    }

    public void addPluginDescriptor(ModuleArchiver archiver) throws MojoFailureException {
        Path pluginPropertiesPath = Paths.get(this.outputDirectory.getAbsolutePath(), CLASSES, "plugin.properties");
        if (pluginPropertiesPath.toFile().exists()) {
            this.doAddArtifactProperties(pluginPropertiesPath.toFile());
            archiver.addFile(pluginPropertiesPath.toFile(), "plugin.properties");
        } else {
            Path pluginJsonPath = Paths.get(this.outputDirectory.getAbsolutePath(), CLASSES, META_INF, MULE_ARTIFACT, "mule-plugin.json");
            if (!pluginJsonPath.toFile().exists()) {
                throw new MojoFailureException(String.format("At least one of %s or %s is expected", pluginPropertiesPath.toString(), pluginJsonPath.toString()));
            }
            archiver.addFile(pluginJsonPath.toFile(), MULE_PLUGIN_JSON_LOCATION);
        }
    }

    protected void doAddArtifactProperties(File pluginPropertiesFile) throws MojoFailureException {
        if (!pluginPropertiesFile.exists()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(this.getPluginPropertiesFile());
            Properties loadProps = new Properties();
            loadProps.load(is);
            FileOutputStream os = new FileOutputStream(pluginPropertiesFile);
            PluginProperties pluginProperties = new PluginProperties(loadProps.getProperty("artifact.export.classPackages"), loadProps.getProperty("artifact.export.resources"), StringUtils.join((Collection)this.getPluginDependencies(), (String)","), loadProps.getProperty("plugin.bundle"));
            pluginProperties.writeTo(os);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error copying properties file " + e.getMessage());
        }
    }

    private File getPluginPropertiesFile() {
        if (this.customPluginProperties.exists()) {
            return this.customPluginProperties;
        }
        return new File(this.baseDir, "src/main/resources/plugin.properties");
    }

    protected String getArtifactType() {
        return "jar";
    }

    protected String getArtifactClassifier() {
        return "mule-plugin";
    }

    protected File getMuleArtifactFile() {
        return new File(this.outputDirectory, this.finalName + "-" + "mule-plugin" + ".jar");
    }
}

