/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.plugin.maven;

import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ServiceProperties extends PluginProperties {

  public static final String SERVICE_PROVIDER_CLASS_NAME = "service.className";

  private String provider;

  public ServiceProperties(String provider, List<String> exportedPackageNames, List<String> exportedResources,
                           Set<String> pluginDependencies) {
    super(exportedPackageNames, exportedResources, pluginDependencies);
    this.provider = provider;
  }

  public ServiceProperties(String provider, String exportedPackages, String exportedResources, String pluginDependencies,
                           String pluginBundle) {
    super(exportedPackages, exportedResources, pluginDependencies, pluginBundle);
    this.provider = provider;
  }

  @Override
  protected void doWriteProperties(Properties properties) {
    super.doWriteProperties(properties);
    properties.setProperty(SERVICE_PROVIDER_CLASS_NAME, provider);
  }
}
