/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.plugin.maven.AbstractPackagePluginMojo;
import org.mule.plugin.maven.ModuleArchiver;
import org.mule.plugin.maven.ServiceProperties;

@Mojo(name="package-service", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ServicePackageMojo
extends AbstractPackagePluginMojo {
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File baseDir;
    @Parameter(defaultValue="service.properties")
    private File customServiceProperties;

    protected void addToArchiver(ModuleArchiver archiver) throws MojoFailureException {
        this.addServiceJar(archiver);
        super.addToArchiver(archiver);
    }

    private void addServiceJar(ModuleArchiver archiver) throws MojoFailureException {
        String jarName = this.finalName + ".jar";
        File jar = new File(this.outputDirectory, jarName);
        if (!jar.exists()) {
            throw new MojoFailureException(String.format("Artifact jar <%1s> doesn't exist in target folder", jarName));
        }
        archiver.addLib(jar);
    }

    protected void doAddArtifactProperties(File servicePropertiesFile) throws MojoFailureException {
        try {
            FileInputStream is = new FileInputStream(this.getServicePropertiesFile());
            Properties loadProps = new Properties();
            loadProps.load(is);
            FileOutputStream os = new FileOutputStream(servicePropertiesFile);
            ServiceProperties serviceProperties = new ServiceProperties(loadProps.getProperty("service.className"), loadProps.getProperty("artifact.export.classPackages"), loadProps.getProperty("artifact.export.resources"), StringUtils.join((Collection)this.getPluginDependencies(), (String)","), loadProps.getProperty("plugin.bundle"));
            serviceProperties.writeTo(os);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error copying properties file " + e.getMessage());
        }
    }

    protected void addArtifactProperties(ModuleArchiver moduleArchiver) throws MojoFailureException {
        File pluginPropertiesFile = new File(this.outputDirectory, "service.properties");
        this.doAddArtifactProperties(pluginPropertiesFile);
        moduleArchiver.add(pluginPropertiesFile);
    }

    public File getServicePropertiesFile() {
        if (this.customServiceProperties.exists()) {
            return this.customServiceProperties;
        }
        return new File(this.baseDir, "src/main/resources/service.properties");
    }
}

