/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.extension.maven.ExtensionPackageMojo;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;

public class MavenProjectExtensionModelLoader {
    private final Log log;

    public MavenProjectExtensionModelLoader(Log log) {
        this.log = log;
    }

    public ExtensionModel loadExtension(MavenProject project, MulePluginModel mulePluginDescriber) throws MojoFailureException, MojoExecutionException {
        ClassLoader pluginClassLoader = this.getInvokerClassLoader(project);
        Set<ExtensionModel> extensions = this.getPluginsExtensions(project, pluginClassLoader);
        return this.getExtensionModel(pluginClassLoader, extensions, mulePluginDescriber);
    }

    private Set<ExtensionModel> getPluginsExtensions(MavenProject project, ClassLoader pluginClassLoader) throws MojoFailureException, MojoExecutionException {
        HashSet<MulePluginModel> workedPlugins;
        HashSet<ExtensionModel> extensions = new HashSet<ExtensionModel>();
        Set<MulePluginModel> pluginDescriptors = this.filterPluginsWithExtensionModelLoader(project);
        do {
            workedPlugins = new HashSet<MulePluginModel>();
            for (MulePluginModel mulePluginDescriber : pluginDescriptors) {
                try {
                    extensions.add(this.getExtensionModel(pluginClassLoader, extensions, mulePluginDescriber));
                    workedPlugins.add(mulePluginDescriber);
                }
                catch (RuntimeException e) {
                    this.log.info((CharSequence)String.format("Couldn't resolve ExtensionModel for plugin [%s], trying again later ([%d] more plugins in the bag to work with).", mulePluginDescriber.getName(), pluginDescriptors.size() - 1));
                }
            }
            pluginDescriptors.removeAll(workedPlugins);
        } while (!pluginDescriptors.isEmpty() && !workedPlugins.isEmpty());
        if (!pluginDescriptors.isEmpty()) {
            String unresolvedPlugins = pluginDescriptors.stream().map(AbstractMuleArtifactModel::getName).collect(Collectors.joining(","));
            throw new MojoFailureException(String.format("There are several plugins that are still pending to generate their ExtensionModel. Unresolved plugins: [%s]", unresolvedPlugins));
        }
        return extensions;
    }

    private Set<MulePluginModel> filterPluginsWithExtensionModelLoader(MavenProject project) {
        return project.getArtifacts().stream().filter(artifact -> "mule-plugin".equals(artifact.getClassifier()) && !"test".equals(artifact.getScope())).map(this::getDescriptor).filter(Optional::isPresent).map(Optional::get).filter(mulePluginModel -> mulePluginModel.getExtensionModelLoaderDescriptor().isPresent()).collect(Collectors.toSet());
    }

    private Optional<MulePluginModel> getDescriptor(Artifact artifact) {
        Optional<MulePluginModel> result = Optional.empty();
        try {
            ZipFile pluginJar = new ZipFile(artifact.getFile());
            ZipEntry mulePluginDescriptorEntry = pluginJar.getEntry(ExtensionPackageMojo.MULE_PLUGIN_JSON_JAR_DESTINATION);
            if (mulePluginDescriptorEntry != null) {
                InputStream stream = pluginJar.getInputStream(mulePluginDescriptorEntry);
                result = Optional.of(new MulePluginModelJsonSerializer().deserialize(IOUtils.toString((InputStream)stream)));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Cannot get the file [%s] JAR for the following artifact [%s]", artifact.getFile().getAbsolutePath(), artifact.toString()));
        }
        return result;
    }

    private ExtensionModel getExtensionModel(ClassLoader pluginClassLoader, Set<ExtensionModel> extensions, MulePluginModel mulePluginDescriber) throws MojoExecutionException, MojoFailureException {
        MuleArtifactLoaderDescriptor loaderDescriptor = this.getExtensionLoaderDescriptor(mulePluginDescriber);
        this.log.info((CharSequence)String.format("Creating ExtensionModel for name:[%s], ID:[%s]", mulePluginDescriber.getName(), loaderDescriptor.getId()));
        ExtensionModelLoader extensionModelLoader = this.getExtensionModelLoader(loaderDescriptor.getId(), pluginClassLoader);
        return extensionModelLoader.loadExtensionModel(pluginClassLoader, DslResolvingContext.getDefault(extensions), loaderDescriptor.getAttributes());
    }

    private MuleArtifactLoaderDescriptor getExtensionLoaderDescriptor(MulePluginModel jsonDescriber) throws MojoExecutionException, MojoFailureException {
        return (MuleArtifactLoaderDescriptor)jsonDescriber.getExtensionModelLoaderDescriptor().orElseThrow(() -> new MojoExecutionException(String.format("The plugin [%s] does not have a ExtensionLoader descriptor, nothing to generate so far.", jsonDescriber.getName())));
    }

    private ClassLoader getInvokerClassLoader(MavenProject project) throws MojoFailureException {
        List invokerClasspathElements;
        try {
            invokerClasspathElements = project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException("There was an issue trying to consume the classpath for the current project.", (Throwable)e);
        }
        invokerClasspathElements.add(project.getBuild().getOutputDirectory());
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)String.format("Classpath to process: [%s]", String.join((CharSequence)",", invokerClasspathElements)));
        }
        URL[] urls = new URL[invokerClasspathElements.size()];
        for (int i = 0; i < invokerClasspathElements.size(); ++i) {
            String invokerClasspathElement = (String)invokerClasspathElements.get(i);
            try {
                urls[i] = new File(invokerClasspathElement).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new MojoFailureException(String.format("There was an issue trying to convert the element [%s] to an URL. Full classpath: [%s]", invokerClasspathElement, String.join((CharSequence)",", invokerClasspathElements)));
            }
        }
        return new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    private ExtensionModelLoader getExtensionModelLoader(String id, ClassLoader pluginClassLoader) throws MojoFailureException {
        ArrayList<String> foundIds = new ArrayList<String>();
        ServiceLoader<ExtensionModelLoader> extensionModelLoaders = ServiceLoader.load(ExtensionModelLoader.class, pluginClassLoader);
        for (ExtensionModelLoader extensionModelLoader : extensionModelLoaders) {
            foundIds.add(String.format("Class:[%s]; ID:[%s].", extensionModelLoader.getClass().getName(), extensionModelLoader.getId()));
            if (!id.equals(extensionModelLoader.getId())) continue;
            return extensionModelLoader;
        }
        throw new MojoFailureException(String.format("Failure while looking for an implementation class of [%s] class through SPI for the ID [%s]. Found resources: \n%s", ExtensionModelLoader.class.getName(), id, String.join((CharSequence)", \n", foundIds)));
    }
}

